/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.tomcat;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import cn.jiangzeyin.common.validator.ValidatorItem;
import cn.jiangzeyin.common.validator.ValidatorRule;
import cn.jiangzeyin.controller.multipart.MultipartFileBuilder;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.BaseAgentController;
import io.jpom.common.commander.AbstractTomcatCommander;
import io.jpom.controller.tomcat.TomcatOp;
import io.jpom.model.data.TomcatInfoModel;
import io.jpom.service.manage.TomcatEditService;
import io.jpom.service.manage.TomcatManageService;
import io.jpom.socket.AgentFileTailWatcher;
import io.jpom.util.LayuiTreeUtil;
import io.jpom.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tomcat/"})
public class TomcatManageController
extends BaseAgentController {
    @Resource
    private TomcatEditService tomcatEditService;
    @Resource
    private TomcatManageService tomcatManageService;

    @RequestMapping(value={"getTomcatProjectList"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getTomcatProjectList(String id) {
        JSONArray array = this.tomcatManageService.getTomcatProjectList(id);
        return JsonMessage.getString((int)200, (String)"\u67e5\u8be2\u6210\u529f", (Object)array);
    }

    @RequestMapping(value={"getTomcatStatus"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getStatus(String id) {
        return JsonMessage.getString((int)200, (String)"\u67e5\u8be2\u6210\u529f", (Object)this.tomcatManageService.getTomcatStatus(id));
    }

    @RequestMapping(value={"start"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String start(String id) {
        TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(id);
        String result = AbstractTomcatCommander.getInstance().execCmd(tomcatInfoModel, "start");
        String msg = "\u542f\u52a8\u6210\u529f";
        if ("stopped".equals(result)) {
            msg = "\u542f\u52a8\u5931\u8d25";
        }
        return JsonMessage.getString((int)200, (String)msg, (Object)result);
    }

    @RequestMapping(value={"stop"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String stop(String id) {
        TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(id);
        String result = AbstractTomcatCommander.getInstance().execCmd(tomcatInfoModel, "stop");
        String msg = "\u505c\u6b62\u6210\u529f";
        if ("started".equals(result)) {
            msg = "\u505c\u6b62\u5931\u8d25";
        }
        return JsonMessage.getString((int)200, (String)msg, (Object)result);
    }

    @RequestMapping(value={"restart"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String restart(String id) {
        TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(id);
        String stopResult = AbstractTomcatCommander.getInstance().execCmd(tomcatInfoModel, "stop");
        String startResult = AbstractTomcatCommander.getInstance().execCmd(tomcatInfoModel, "start");
        return JsonMessage.getString((int)200, (String)StrUtil.format((CharSequence)"\u91cd\u542f\u6210\u529f {}  {}", (Object[])new Object[]{stopResult, startResult}));
    }

    @RequestMapping(value={"tomcatProjectManage"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String tomcatProjectManage(String id, String path, @ValidatorItem(value=ValidatorRule.NOT_BLANK, msg="\u64cd\u4f5c\u9879\u4e0d\u5bf9") String op) {
        TomcatOp tomcatOp = TomcatOp.valueOf(op);
        return this.tomcatManageService.tomcatProjectManage(id, path, tomcatOp).toString();
    }

    @RequestMapping(value={"getFileList"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getFileList(String id, String path) {
        TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(id);
        if (tomcatInfoModel == null) {
            return JsonMessage.getString((int)500, (String)"\u67e5\u8be2\u5931\u8d25\uff1a\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        if (StrUtil.isEmptyOrUndefined((CharSequence)path)) {
            return JsonMessage.getString((int)500, (String)"path value error");
        }
        String appBasePath = tomcatInfoModel.getAppBase();
        File fileDir = FileUtil.file((String)appBasePath, (String)FileUtil.normalize((String)path));
        if (!fileDir.exists()) {
            return JsonMessage.getString((int)500, (String)"\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        File[] filesAll = fileDir.listFiles();
        if (filesAll == null) {
            return JsonMessage.getString((int)500, (String)"\u76ee\u5f55\u662f\u7a7a");
        }
        JSONArray arrayFile = new JSONArray();
        JSONArray arrayDir = new JSONArray();
        for (File file : filesAll) {
            JSONObject jsonObject = new JSONObject();
            String parentPath = StringUtil.delStartPath((File)file, (String)appBasePath, (boolean)false);
            jsonObject.put("parentPath", (Object)parentPath);
            jsonObject.put("filename", (Object)file.getName());
            long mTime = file.lastModified();
            jsonObject.put("modifyTimeLong", (Object)mTime);
            jsonObject.put("modifyTime", (Object)DateUtil.date((long)mTime).toString());
            if (file.isDirectory()) {
                jsonObject.put("isDirectory", (Object)true);
                long sizeFile = FileUtil.size((File)file);
                jsonObject.put("fileSize", (Object)FileUtil.readableFileSize((long)sizeFile));
                arrayDir.add((Object)jsonObject);
                continue;
            }
            jsonObject.put("fileSize", (Object)FileUtil.readableFileSize((long)file.length()));
            arrayFile.add((Object)jsonObject);
        }
        JSONArray resultArray = new JSONArray();
        resultArray.addAll((Collection)arrayDir);
        resultArray.addAll((Collection)arrayFile);
        return JsonMessage.getString((int)200, (String)"\u67e5\u8be2\u6210\u529f", (Object)resultArray);
    }

    @RequestMapping(value={"upload"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String upload(String id, String path) {
        TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(id);
        MultipartFileBuilder multipartFileBuilder = this.createMultipart().addFieldName("file");
        File dir = new File(tomcatInfoModel.getAppBase().concat(FileUtil.normalize((String)path)));
        multipartFileBuilder.setSavePath(dir.getAbsolutePath()).setUseOriginalFilename(true);
        try {
            multipartFileBuilder.save();
        }
        catch (IOException e) {
            return JsonMessage.getString((int)500, (String)"\u4e0a\u4f20\u5f02\u5e38");
        }
        return JsonMessage.getString((int)200, (String)"\u4e0a\u4f20\u6210\u529f");
    }

    @RequestMapping(value={"uploadWar"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String uploadWar(String id) {
        TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(id);
        MultipartFileBuilder multipartFileBuilder = this.createMultipart().addFieldName("file");
        File dir = new File(tomcatInfoModel.getAppBase());
        multipartFileBuilder.setSavePath(dir.getAbsolutePath()).setUseOriginalFilename(true);
        try {
            multipartFileBuilder.save();
        }
        catch (IOException e) {
            return JsonMessage.getString((int)500, (String)"\u4e0a\u4f20\u5f02\u5e38");
        }
        return JsonMessage.getString((int)200, (String)"\u4e0a\u4f20\u6210\u529f");
    }

    @RequestMapping(value={"deleteFile"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String deleteFile(String id, String path, String filename) {
        File file;
        TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(id);
        if (tomcatInfoModel == null) {
            return JsonMessage.getString((int)500, (String)"tomcat\u4e0d\u5b58\u5728");
        }
        if ("_tomcat_log".equals(path)) {
            file = FileUtil.file((String[])new String[]{tomcatInfoModel.getPath(), "logs", filename});
            long modified = file.lastModified();
            if (System.currentTimeMillis() - modified < TimeUnit.DAYS.toMillis(1L)) {
                return JsonMessage.getString((int)405, (String)"\u4e0d\u80fd\u5220\u9664\u5f53\u5929\u7684\u65e5\u5fd7");
            }
            AgentFileTailWatcher.offlineFile(file);
        } else {
            file = FileUtil.file((String[])new String[]{tomcatInfoModel.getAppBase(), path, filename});
        }
        if (file.exists()) {
            if (file.delete()) {
                return JsonMessage.getString((int)200, (String)"\u5220\u9664\u6210\u529f");
            }
            return JsonMessage.getString((int)500, (String)"\u5220\u9664\u5931\u8d25");
        }
        return JsonMessage.getString((int)404, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
    }

    @RequestMapping(value={"download"}, method={RequestMethod.GET})
    public String download(String id, String path, String filename) {
        filename = FileUtil.normalize((String)filename);
        path = FileUtil.normalize((String)path);
        try {
            TomcatInfoModel tomcatInfoModel = (TomcatInfoModel)this.tomcatEditService.getItem(id);
            File file = "_tomcat_log".equals(path) ? FileUtil.file((String[])new String[]{tomcatInfoModel.getPath(), "logs", filename}) : FileUtil.file((String[])new String[]{tomcatInfoModel.getAppBase(), path, filename});
            if (file.isDirectory()) {
                return "\u6682\u4e0d\u652f\u6301\u4e0b\u8f7d\u6587\u4ef6\u5939";
            }
            ServletUtil.write((HttpServletResponse)this.getResponse(), (File)file);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        return "\u4e0b\u8f7d\u5931\u8d25\u3002\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5";
    }

    @RequestMapping(value={"logList"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String logList(String id) {
        TomcatInfoModel item = (TomcatInfoModel)this.tomcatEditService.getItem(id);
        if (item == null) {
            return JsonMessage.getString((int)300, (String)"\u6ca1\u6709\u5bf9\u5e94\u6570\u636e");
        }
        JSONArray jsonArray = LayuiTreeUtil.getTreeData((String)FileUtil.file((String)item.pathAndCheck(), (String)"logs").getAbsolutePath());
        return JsonMessage.getString((int)200, (String)"", (Object)jsonArray);
    }
}

