/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.tomcat;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.crypto.SecureUtil;
import cn.jiangzeyin.common.JsonMessage;
import io.jpom.common.BaseAgentController;
import io.jpom.model.data.TomcatInfoModel;
import io.jpom.service.manage.TomcatEditService;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tomcat/"})
public class TomcatEditController
extends BaseAgentController {
    @Resource
    private TomcatEditService tomcatEditService;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String list() {
        List tomcatInfoModels = this.tomcatEditService.list();
        return JsonMessage.getString((int)200, (String)"\u67e5\u8be2\u6210\u529f", (Object)tomcatInfoModels);
    }

    @RequestMapping(value={"getItem"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getItem(String id) {
        return JsonMessage.getString((int)200, (String)"\u67e5\u8be2\u6210\u529f", (Object)this.tomcatEditService.getItem(id));
    }

    @RequestMapping(value={"add"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String add(TomcatInfoModel tomcatInfoModel) {
        String name = tomcatInfoModel.getName();
        TomcatInfoModel tomcatInfoModelTemp = this.tomcatEditService.getItemByName(name);
        if (tomcatInfoModelTemp != null) {
            return JsonMessage.getString((int)401, (String)"\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4f7f\u7528\u5176\u4ed6\u540d\u79f0\uff01");
        }
        tomcatInfoModel.setId(SecureUtil.md5((String)DateUtil.now()));
        tomcatInfoModel.setCreator(this.getUserName());
        tomcatInfoModel.setPath(FileUtil.normalize((String)tomcatInfoModel.getPath()));
        Objects.requireNonNull(tomcatInfoModel.pathAndCheck());
        this.tomcatEditService.addItem(tomcatInfoModel);
        tomcatInfoModel.initTomcat();
        return JsonMessage.getString((int)200, (String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"update"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String update(TomcatInfoModel tomcatInfoModel) {
        String name = tomcatInfoModel.getName();
        TomcatInfoModel tomcatInfoModelTemp = this.tomcatEditService.getItemByName(name);
        if (tomcatInfoModelTemp != null && !tomcatInfoModelTemp.getId().equals(tomcatInfoModel.getId())) {
            return JsonMessage.getString((int)401, (String)"\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4f7f\u7528\u5176\u4ed6\u540d\u79f0\uff01");
        }
        tomcatInfoModel.setModifyUser(this.getUserName());
        tomcatInfoModel.setPath(FileUtil.normalize((String)tomcatInfoModel.getPath()));
        Objects.requireNonNull(tomcatInfoModel.pathAndCheck());
        this.tomcatEditService.updateItem(tomcatInfoModel);
        tomcatInfoModel.initTomcat();
        return JsonMessage.getString((int)200, (String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String delete(String id) {
        this.tomcatEditService.deleteItem(id);
        return JsonMessage.getString((int)200, (String)"\u5220\u9664\u6210\u529f");
    }
}

