/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.system;

import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.JsonMessage;
import io.jpom.common.BaseJpomController;
import io.jpom.model.data.AgentWhitelist;
import io.jpom.service.WhitelistDirectoryService;
import io.jpom.system.AgentExtConfigBean;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system"})
public class WhitelistDirectoryController
extends BaseJpomController {
    @Resource
    private WhitelistDirectoryService whitelistDirectoryService;

    @RequestMapping(value={"whitelistDirectory_data"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String whiteListDirectoryData() {
        AgentWhitelist agentWhitelist = this.whitelistDirectoryService.getWhitelist();
        return JsonMessage.getString((int)200, (String)"", (Object)agentWhitelist);
    }

    @RequestMapping(value={"whitelistDirectory_submit"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String whitelistDirectorySubmit(String project, String certificate, String nginx) {
        List certificateList = null;
        if (StrUtil.isNotEmpty((CharSequence)certificate) && ((certificateList = StrSpliter.splitTrim((String)certificate, (String)"\n", (boolean)true)) == null || certificateList.size() <= 0)) {
            return JsonMessage.getString((int)401, (String)"\u8bc1\u4e66\u8def\u5f84\u767d\u540d\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List nList = null;
        if (StrUtil.isNotEmpty((CharSequence)nginx) && ((nList = StrSpliter.splitTrim((String)nginx, (String)"\n", (boolean)true)) == null || nList.size() <= 0)) {
            return JsonMessage.getString((int)401, (String)"nginx\u8def\u5f84\u767d\u540d\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.save(project, (List<String>)certificateList, (List<String>)nList).toString();
    }

    private JsonMessage save(String project, List<String> certificate, List<String> nginx) {
        if (StrUtil.isEmpty((CharSequence)project)) {
            return new JsonMessage(401, "\u9879\u76ee\u8def\u5f84\u767d\u540d\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = StrSpliter.splitTrim((String)project, (String)"\n", (boolean)true);
        if (list == null || list.size() <= 0) {
            return new JsonMessage(401, "\u9879\u76ee\u8def\u5f84\u767d\u540d\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.save(list, certificate, nginx);
    }

    private JsonMessage save(List<String> projects, List<String> certificate, List<String> nginx) {
        AgentWhitelist agentWhitelist;
        List projectArray = AgentWhitelist.covertToArray(projects);
        if (projectArray == null) {
            return new JsonMessage(401, "\u9879\u76ee\u8def\u5f84\u767d\u540d\u5355\u4e0d\u80fd\u4f4d\u4e8eJpom\u76ee\u5f55\u4e0b");
        }
        if (projectArray.isEmpty()) {
            return new JsonMessage(401, "\u9879\u76ee\u8def\u5f84\u767d\u540d\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String error = this.findStartsWith(projectArray, 0);
        if (error != null) {
            return new JsonMessage(401, "\u767d\u540d\u5355\u76ee\u5f55\u4e2d\u4e0d\u80fd\u5b58\u5728\u5305\u542b\u5173\u7cfb\uff1a" + error);
        }
        List certificateArray = null;
        if (certificate != null && !certificate.isEmpty()) {
            certificateArray = AgentWhitelist.covertToArray(certificate);
            if (certificateArray == null) {
                return new JsonMessage(401, "\u8bc1\u4e66\u8def\u5f84\u767d\u540d\u5355\u4e0d\u80fd\u4f4d\u4e8eJpom\u76ee\u5f55\u4e0b");
            }
            if (certificateArray.isEmpty()) {
                return new JsonMessage(401, "\u8bc1\u4e66\u8def\u5f84\u767d\u540d\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String error2 = this.findStartsWith(certificateArray, 0);
            if (error2 != null) {
                return new JsonMessage(401, "\u8bc1\u4e66\u76ee\u5f55\u4e2d\u4e0d\u80fd\u5b58\u5728\u5305\u542b\u5173\u7cfb\uff1a" + error2);
            }
        }
        List nginxArray = null;
        if (nginx != null && !nginx.isEmpty()) {
            nginxArray = AgentWhitelist.covertToArray(nginx);
            if (nginxArray == null) {
                return new JsonMessage(401, "nginx\u8def\u5f84\u767d\u540d\u5355\u4e0d\u80fd\u4f4d\u4e8eJpom\u76ee\u5f55\u4e0b");
            }
            if (nginxArray.isEmpty()) {
                return new JsonMessage(401, "nginx\u8def\u5f84\u767d\u540d\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String error3 = this.findStartsWith(nginxArray, 0);
            if (error3 != null) {
                return new JsonMessage(401, "nginx\u76ee\u5f55\u4e2d\u4e0d\u80fd\u5b58\u5728\u5305\u542b\u5173\u7cfb\uff1a" + error3);
            }
        }
        if ((agentWhitelist = this.whitelistDirectoryService.getWhitelist()) == null) {
            agentWhitelist = new AgentWhitelist();
        }
        agentWhitelist.setProject(projectArray);
        agentWhitelist.setCertificate(certificateArray);
        agentWhitelist.setNginx(nginxArray);
        this.whitelistDirectoryService.saveWhitelistDirectory(agentWhitelist);
        return new JsonMessage(200, "\u4fdd\u5b58\u6210\u529f");
    }

    private String findStartsWith(List<String> jsonArray, int start) {
        if (!AgentExtConfigBean.getInstance().whitelistDirectoryCheckStartsWith) {
            return null;
        }
        String str = jsonArray.get(start);
        int len = jsonArray.size();
        for (int i = 0; i < len; ++i) {
            String findStr;
            if (i == start || !(findStr = jsonArray.get(i)).startsWith(str)) continue;
            return str;
        }
        if (start < len - 1) {
            return this.findStartsWith(jsonArray, start + 1);
        }
        return null;
    }
}

