/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.system;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import cn.jiangzeyin.common.validator.ValidatorItem;
import cn.jiangzeyin.common.validator.ValidatorRule;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.odiszapc.nginxparser.NgxBlock;
import com.github.odiszapc.nginxparser.NgxConfig;
import com.github.odiszapc.nginxparser.NgxEntry;
import com.github.odiszapc.nginxparser.NgxParam;
import io.jpom.common.BaseAgentController;
import io.jpom.common.commander.AbstractSystemCommander;
import io.jpom.service.WhitelistDirectoryService;
import io.jpom.service.system.NginxService;
import io.jpom.util.CommandUtil;
import io.jpom.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/nginx"})
public class NginxController
extends BaseAgentController {
    @Resource
    private NginxService nginxService;
    @Resource
    private WhitelistDirectoryService whitelistDirectoryService;

    @RequestMapping(value={"list_data.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String list() {
        JSONArray array = this.nginxService.list();
        return JsonMessage.getString((int)200, (String)"", (Object)array);
    }

    @RequestMapping(value={"item_data"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String itemData(String path, String name) {
        String newName = NginxController.pathSafe((String)name);
        if (this.whitelistDirectoryService.checkNgxDirectory(path)) {
            File file = FileUtil.file((String)path, (String)newName);
            JSONObject jsonObject = new JSONObject();
            String string = FileUtil.readUtf8String((File)file);
            jsonObject.put("context", (Object)string);
            String rName = StringUtil.delStartPath((File)file, (String)path, (boolean)true);
            jsonObject.put("name", (Object)rName);
            jsonObject.put("whitePath", (Object)path);
            return JsonMessage.getString((int)200, (String)"", (Object)jsonObject);
        }
        return JsonMessage.getString((int)400, (String)"\u9519\u8bef");
    }

    @RequestMapping(value={"updateNgx"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String updateNgx(String name, String whitePath, String genre) {
        if (StrUtil.isEmpty((CharSequence)name)) {
            return JsonMessage.getString((int)400, (String)"\u8bf7\u586b\u5199\u6587\u4ef6\u540d");
        }
        if (!name.endsWith(".conf")) {
            return JsonMessage.getString((int)400, (String)"\u6587\u4ef6\u540e\u7f00\u5fc5\u987b\u4e3a\".conf\"");
        }
        if (!this.checkPathSafe(name)) {
            return JsonMessage.getString((int)400, (String)"\u6587\u4ef6\u540d\u5b58\u5728\u975e\u6cd5\u5b57\u7b26");
        }
        if (!this.whitelistDirectoryService.checkNgxDirectory(whitePath)) {
            return JsonMessage.getString((int)400, (String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u767d\u540d\u5355");
        }
        File file = FileUtil.file((String)whitePath, (String)name);
        if ("add".equals(genre) && file.exists()) {
            return JsonMessage.getString((int)400, (String)"\u8be5\u6587\u4ef6\u5df2\u5b58\u5728");
        }
        String context = this.getUnescapeParameter("context");
        if (StrUtil.isEmpty((CharSequence)context)) {
            return JsonMessage.getString((int)400, (String)"\u8bf7\u586b\u5199\u914d\u7f6e\u4fe1\u606f");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(context.getBytes());
        try {
            NgxConfig conf = NgxConfig.read((InputStream)inputStream);
            List list = conf.findAll(NgxBlock.class, new String[]{"server"});
            if (list == null || list.size() <= 0) {
                return JsonMessage.getString((int)404, (String)"\u5185\u5bb9\u89e3\u6790\u4e3a\u7a7a");
            }
            for (NgxEntry ngxEntry : list) {
                NgxParam sslCertificate;
                NgxBlock ngxBlock = (NgxBlock)ngxEntry;
                NgxParam accessLog = ngxBlock.findParam(new String[]{"access_log"});
                if (accessLog != null) {
                    FileUtil.mkParentDirs((String)accessLog.getValue());
                }
                if ((accessLog = ngxBlock.findParam(new String[]{"error_log"})) != null) {
                    FileUtil.mkParentDirs((String)accessLog.getValue());
                }
                if ((sslCertificate = ngxBlock.findParam(new String[]{"ssl_certificate"})) != null && !FileUtil.exist((String)sslCertificate.getValue())) {
                    return JsonMessage.getString((int)404, (String)"\u8bc1\u4e66\u6587\u4ef6ssl_certificate,\u4e0d\u5b58\u5728");
                }
                NgxParam sslCertificateKey = ngxBlock.findParam(new String[]{"ssl_certificate_key"});
                if (sslCertificateKey != null && !FileUtil.exist((String)sslCertificateKey.getValue())) {
                    return JsonMessage.getString((int)404, (String)"\u8bc1\u4e66\u6587\u4ef6ssl_certificate_key,\u4e0d\u5b58\u5728");
                }
                if (this.checkRootRole(ngxBlock)) continue;
                return JsonMessage.getString((int)405, (String)"\u975e\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u914d\u7f6e\u9759\u6001\u8d44\u6e90\u4ee3\u7406");
            }
        }
        catch (IOException e) {
            DefaultSystemLog.ERROR().error("\u89e3\u6790\u5931\u8d25", (Throwable)e);
            return JsonMessage.getString((int)500, (String)"\u89e3\u6790\u5931\u8d25");
        }
        try {
            FileUtil.writeString((String)context, (File)file, (String)"UTF-8");
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
            return JsonMessage.getString((int)400, (String)("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage()));
        }
        String msg = this.reloadNginx();
        return JsonMessage.getString((int)200, (String)("\u63d0\u4ea4\u6210\u529f" + msg));
    }

    private String reloadNginx() {
        try {
            String msg = CommandUtil.execSystemCommand((String)"nginx -s reload");
            if (StrUtil.isNotEmpty((CharSequence)msg)) {
                DefaultSystemLog.LOG().info(msg);
                return "(" + msg + ")";
            }
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("reload nginx error", (Throwable)e);
        }
        return "";
    }

    private boolean checkRootRole(NgxBlock ngxBlock) {
        return true;
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String delete(String path, String name) {
        if (!this.whitelistDirectoryService.checkNgxDirectory(path)) {
            return JsonMessage.getString((int)400, (String)"\u975e\u6cd5\u64cd\u4f5c");
        }
        String safePath = NginxController.pathSafe((String)path);
        String safeName = NginxController.pathSafe((String)name);
        if (StrUtil.isEmpty((CharSequence)safeName)) {
            return JsonMessage.getString((int)400, (String)"\u5220\u9664\u5931\u8d25,\u8bf7\u6b63\u5e38\u64cd\u4f5c");
        }
        File file = FileUtil.file((String)safePath, (String)safeName);
        try {
            FileUtil.rename((File)file, (String)(file.getName() + "_back"), (boolean)false, (boolean)true);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u5220\u9664nginx", (Throwable)e);
            return JsonMessage.getString((int)400, (String)("\u5220\u9664\u5931\u8d25:" + e.getMessage()));
        }
        String msg = this.reloadNginx();
        return JsonMessage.getString((int)200, (String)("\u5220\u9664\u6210\u529f" + msg));
    }

    @RequestMapping(value={"status"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String status() {
        JSONObject ngxConf = this.nginxService.getNgxConf();
        String name = ngxConf.getString("name");
        if (StrUtil.isEmpty((CharSequence)name)) {
            return JsonMessage.getString((int)500, (String)"\u670d\u52a1\u540d\u9519\u8bef");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)name);
        boolean serviceStatus = AbstractSystemCommander.getInstance().getServiceStatus(name);
        jsonObject.put("status", (Object)serviceStatus);
        return JsonMessage.getString((int)200, (String)"", (Object)jsonObject);
    }

    @RequestMapping(value={"updateConf"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String updateConf(@ValidatorItem(value=ValidatorRule.NOT_BLANK, msg="\u670d\u52a1\u540d\u79f0\u9519\u8bef") String name) {
        JSONObject ngxConf = this.nginxService.getNgxConf();
        ngxConf.put("name", (Object)name);
        this.nginxService.save(ngxConf);
        return JsonMessage.getString((int)200, (String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"config"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String config() {
        JSONObject ngxConf = this.nginxService.getNgxConf();
        return JsonMessage.getString((int)200, (String)"", (Object)ngxConf);
    }

    @RequestMapping(value={"open"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String open() {
        JSONObject ngxConf = this.nginxService.getNgxConf();
        String name = ngxConf.getString("name");
        String result = AbstractSystemCommander.getInstance().startService(name);
        return JsonMessage.getString((int)200, (String)("nginx\u670d\u52a1\u5df2\u542f\u52a8 " + result));
    }

    @RequestMapping(value={"close"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String close() {
        JSONObject ngxConf = this.nginxService.getNgxConf();
        String name = ngxConf.getString("name");
        String result = AbstractSystemCommander.getInstance().stopService(name);
        return JsonMessage.getString((int)200, (String)result);
    }

    @RequestMapping(value={"reload"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String reload() {
        if (SystemUtil.getOsInfo().isLinux()) {
            String result = CommandUtil.execSystemCommand((String)"nginx -t");
            if (StrUtil.isNotEmpty((CharSequence)result)) {
                return JsonMessage.getString((int)400, (String)result);
            }
            CommandUtil.execSystemCommand((String)"nginx -s reload");
        } else if (SystemUtil.getOsInfo().isWindows()) {
            JSONObject ngxConf = this.nginxService.getNgxConf();
            String name = ngxConf.getString("name");
            String result = CommandUtil.execSystemCommand((String)("sc qc " + name));
            List strings = StrSpliter.splitTrim((String)result, (String)"\n", (boolean)true);
            File file = null;
            for (String str : strings) {
                if (!(str = str.toUpperCase().trim()).startsWith("BINARY_PATH_NAME")) continue;
                String path = str.substring(str.indexOf(":") + 1).replace("\"", "").trim();
                file = FileUtil.file((String)path).getParentFile();
                break;
            }
            if (StrUtil.isNotEmpty((CharSequence)(result = CommandUtil.execSystemCommand((String)"nginx -t", file)))) {
                return JsonMessage.getString((int)400, (String)result);
            }
            CommandUtil.execSystemCommand((String)"nginx -s reload", file);
        }
        return JsonMessage.getString((int)200, (String)"\u91cd\u65b0\u52a0\u8f7d\u6210\u529f");
    }
}

