/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.system;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.BaseAgentController;
import io.jpom.model.data.CertModel;
import io.jpom.service.WhitelistDirectoryService;
import io.jpom.service.system.CertService;
import io.jpom.system.AgentConfigBean;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/certificate"})
public class CertificateController
extends BaseAgentController {
    @Resource
    private CertService certService;
    @Resource
    private WhitelistDirectoryService whitelistDirectoryService;

    @RequestMapping(value={"/saveCertificate"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String saveCertificate() {
        String data = this.getParameter("data");
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        String type = jsonObject.getString("type");
        String id = jsonObject.getString("id");
        try {
            if ("add".equalsIgnoreCase(type)) {
                if (this.certService.getItem(id) != null) {
                    return JsonMessage.getString((int)405, (String)"\u8bc1\u4e66id\u5df2\u7ecf\u5b58\u5728\u5566");
                }
                CertModel certModel = new CertModel();
                String error = this.getCertModel(certModel, jsonObject);
                if (error != null) {
                    return error;
                }
                if (!this.hasFile()) {
                    return JsonMessage.getString((int)405, (String)"\u8bf7\u9009\u62e9\u8bc1\u4e66\u5305\u6587\u4ef6");
                }
                error = this.getCertFile(certModel, true);
                if (error != null) {
                    return error;
                }
                this.certService.addItem(certModel);
            } else {
                String error;
                CertModel certModel = (CertModel)this.certService.getItem(id);
                if (certModel == null) {
                    return JsonMessage.getString((int)404, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8bc1\u4e66\u6587\u4ef6");
                }
                String name = jsonObject.getString("name");
                if (StrUtil.isEmpty((CharSequence)name)) {
                    return JsonMessage.getString((int)400, (String)"\u8bf7\u586b\u5199\u8bc1\u4e66\u540d\u79f0");
                }
                certModel.setName(name);
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)this.getRequest()) && this.hasFile() && (error = this.getCertFile(certModel, false)) != null) {
                    return error;
                }
                this.certService.updateItem(certModel);
            }
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u8bc1\u4e66\u6587\u4ef6", (Throwable)e);
            return JsonMessage.getString((int)400, (String)("\u89e3\u6790\u8bc1\u4e66\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return JsonMessage.getString((int)200, (String)"\u63d0\u4ea4\u6210\u529f");
    }

    private String getCertModel(CertModel certModel, JSONObject jsonObject) {
        String id = jsonObject.getString("id");
        String path = jsonObject.getString("path");
        String name = jsonObject.getString("name");
        if (StrUtil.isEmpty((CharSequence)id)) {
            return JsonMessage.getString((int)400, (String)"\u8bf7\u586b\u5199\u8bc1\u4e66id");
        }
        if (Validator.isChinese((CharSequence)id)) {
            return JsonMessage.getString((int)400, (String)"\u8bc1\u4e66id\u4e0d\u80fd\u4f7f\u7528\u4e2d\u6587");
        }
        if (StrUtil.isEmpty((CharSequence)name)) {
            return JsonMessage.getString((int)400, (String)"\u8bf7\u586b\u5199\u8bc1\u4e66\u540d\u79f0");
        }
        if (!this.whitelistDirectoryService.checkCertificateDirectory(path)) {
            return JsonMessage.getString((int)400, (String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u9879\u76ee\u8def\u5f84,\u6216\u8005\u8fd8\u6ca1\u6709\u914d\u7f6e\u767d\u540d\u5355");
        }
        certModel.setId(id);
        certModel.setWhitePath(path);
        certModel.setName(name);
        return null;
    }

    private Object getUpdateFileInfo(CertModel certModel, String certPath) throws IOException {
        String pemPath = null;
        String keyPath = null;
        String path = AgentConfigBean.getInstance().getTempPathName();
        try (ZipFile zipFile = new ZipFile(certPath);){
            Object object;
            Object zipEntry;
            Enumeration<? extends ZipEntry> zipEntryEnumeration = zipFile.entries();
            while (zipEntryEnumeration.hasMoreElements()) {
                zipEntry = zipEntryEnumeration.nextElement();
                if (((ZipEntry)zipEntry).isDirectory()) continue;
                String keyName = ((ZipEntry)zipEntry).getName();
                if (pemPath == null && (StrUtil.endWith((CharSequence)keyName, (CharSequence)".pem", (boolean)true) || StrUtil.endWith((CharSequence)keyName, (CharSequence)".cer", (boolean)true) || StrUtil.endWith((CharSequence)keyName, (CharSequence)".crt", (boolean)true))) {
                    String eNmae = FileUtil.extName((String)keyName);
                    CertModel.Type type = CertModel.Type.valueOf(eNmae.toLowerCase());
                    String filePathItem = String.format("%s/%s/%s", path, certModel.getId(), keyName);
                    InputStream inputStream = zipFile.getInputStream((ZipEntry)zipEntry);
                    FileUtil.writeFromStream((InputStream)inputStream, (String)filePathItem);
                    certModel.setType(type);
                    pemPath = filePathItem;
                }
                if (keyPath == null && StrUtil.endWith((CharSequence)keyName, (CharSequence)".key", (boolean)true)) {
                    String filePathItem = String.format("%s/%s/%s", path, certModel.getId(), keyName);
                    InputStream inputStream = zipFile.getInputStream((ZipEntry)zipEntry);
                    FileUtil.writeFromStream((InputStream)inputStream, (String)filePathItem);
                    keyPath = filePathItem;
                }
                if (pemPath == null || keyPath == null) continue;
                break;
            }
            if (pemPath == null || keyPath == null) {
                zipEntry = JsonMessage.getString((int)405, (String)"\u8bc1\u4e66\u5305\u4e2d\u6587\u4ef6\u4e0d\u5b8c\u6574\uff0c\u9700\u8981\u5305\u542bkey\u3001pem");
                return zipEntry;
            }
            JSONObject jsonObject = CertModel.decodeCert(pemPath, keyPath);
            if (jsonObject == null) {
                object = JsonMessage.getString((int)405, (String)"\u89e3\u6790\u8bc1\u4e66\u5931\u8d25");
                return object;
            }
            object = jsonObject;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCertFile(CertModel certModel, boolean add) throws IOException {
        certPath = null;
        try {
            path = AgentConfigBean.getInstance().getTempPathName();
            cert = this.createMultipart().addFieldName("file").setSavePath(path);
            certPath = cert.save();
            val = this.getUpdateFileInfo(certModel, certPath);
            if (val instanceof String) {
                var7_7 = val.toString();
                if (certPath == null) return var7_7;
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var14_19) {
            if (certPath == null) throw var14_19;
            FileUtil.del(certPath);
            throw var14_19;
        }
        FileUtil.del((String)certPath);
        return var7_7;
lbl-1000:
        // 1 sources

        {
            jsonObject = (JSONObject)val;
            domain = jsonObject.getString("domain");
            if (!add) ** GOTO lbl-1000
            array = this.certService.list();
            if (array == null) ** GOTO lbl-1000
            for (CertModel certModel1 : array) {
                if (!StrUtil.emptyToDefault((CharSequence)domain, (String)"").equals(certModel1.getDomain())) continue;
                var12_14 = JsonMessage.getString((int)405, (String)"\u8bc1\u4e66\u7684\u57df\u540d\u5df2\u7ecf\u5b58\u5728\u5566");
                if (certPath == null) return var12_14;
            }
            ** GOTO lbl-1000
        }
        {
            FileUtil.del((String)certPath);
            return var12_14;
            break;
        }
lbl-1000:
        // 1 sources

        {
            if (StrUtil.emptyToDefault((CharSequence)domain, (String)"").equals(certModel.getDomain())) ** GOTO lbl-1000
            array = JsonMessage.getString((int)405, (String)"\u65b0\u8bc1\u4e66\u7684\u57df\u540d\u4e0d\u4e00\u81f4");
            if (certPath == null) return array;
        }
        FileUtil.del((String)certPath);
        return array;
lbl-1000:
        // 3 sources

        {
            temporary = certModel.getWhitePath() + "/" + certModel.getId() + "/";
            pemFile = FileUtil.file((String)(temporary + certModel.getId() + "." + certModel.getType().name()));
            keyFile = FileUtil.file((String)(temporary + certModel.getId() + ".key"));
            if (!add) ** GOTO lbl-1000
            if (!pemFile.exists()) ** GOTO lbl-1000
            var12_15 = JsonMessage.getString((int)405, (String)(pemFile.getAbsolutePath() + " \u5df2\u7ecf\u88ab\u5360\u7528\u5566"));
            if (certPath == null) return var12_15;
        }
        FileUtil.del((String)certPath);
        return var12_15;
lbl-1000:
        // 1 sources

        {
            if (!keyFile.exists()) ** GOTO lbl-1000
            var12_16 = JsonMessage.getString((int)405, (String)(keyFile.getAbsolutePath() + " \u5df2\u7ecf\u88ab\u5360\u7528\u5566"));
            if (certPath == null) return var12_16;
        }
        FileUtil.del((String)certPath);
        return var12_16;
lbl-1000:
        // 2 sources

        {
            pemPath = jsonObject.getString("pemPath");
            keyPath = jsonObject.getString("keyPath");
            FileUtil.move((File)FileUtil.file((String)pemPath), (File)pemFile, (boolean)true);
            FileUtil.move((File)FileUtil.file((String)keyPath), (File)keyFile, (boolean)true);
            certModel.setCert(pemFile.getAbsolutePath());
            certModel.setKey(keyFile.getAbsolutePath());
            certModel.setDomain(domain);
            certModel.setExpirationTime(jsonObject.getLongValue("expirationTime"));
            certModel.setEffectiveTime(jsonObject.getLongValue("effectiveTime"));
            if (certPath == null) return null;
        }
        FileUtil.del((String)certPath);
        return null;
    }

    @RequestMapping(value={"/getCertList"}, produces={"application/json;charset=UTF-8"})
    public String getCertList() {
        List array = this.certService.list();
        return JsonMessage.getString((int)200, (String)"", (Object)array);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String delete(String id) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return JsonMessage.getString((int)400, (String)"\u5220\u9664\u5931\u8d25");
        }
        this.certService.deleteItem(id);
        return JsonMessage.getString((int)200, (String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public String export(String id) {
        CertModel item = (CertModel)this.certService.getItem(id);
        if (null == item) {
            return JsonMessage.getString((int)400, (String)"\u5bfc\u51fa\u5931\u8d25");
        }
        String parent = FileUtil.file((String)item.getCert()).getParent();
        File zip = ZipUtil.zip((String)parent);
        ServletUtil.write((HttpServletResponse)this.getResponse(), (File)zip);
        FileUtil.del((File)zip);
        return JsonMessage.getString((int)400, (String)"\u5bfc\u51fa\u6210\u529f");
    }
}

