/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.script;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import cn.jiangzeyin.common.JsonMessage;
import cn.jiangzeyin.controller.multipart.MultipartFileBuilder;
import io.jpom.common.BaseAgentController;
import io.jpom.model.data.ScriptModel;
import io.jpom.service.script.ScriptServer;
import io.jpom.system.AgentConfigBean;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/script"})
public class ScriptController
extends BaseAgentController {
    @Resource
    private ScriptServer scriptServer;

    @RequestMapping(value={"list.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String list() throws IOException {
        return JsonMessage.getString((int)200, (String)"", this.scriptServer.list());
    }

    @RequestMapping(value={"item.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String item(String id) throws IOException {
        return JsonMessage.getString((int)200, (String)"", (Object)((Object)this.scriptServer.getItem(id)));
    }

    @RequestMapping(value={"save.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String save(ScriptModel scriptModel, String type) throws IOException {
        if (scriptModel == null) {
            return JsonMessage.getString((int)405, (String)"\u6ca1\u6709\u6570\u636e");
        }
        if (StrUtil.isEmpty((CharSequence)scriptModel.getContext())) {
            return JsonMessage.getString((int)405, (String)"\u5185\u5bb9\u4e3a\u7a7a");
        }
        scriptModel.setContext(HtmlUtil.unescape((String)scriptModel.getContext()));
        ScriptModel eModel = this.scriptServer.getItem(scriptModel.getId());
        if ("add".equalsIgnoreCase(type)) {
            if (eModel != null) {
                return JsonMessage.getString((int)405, (String)"id\u5df2\u7ecf\u5b58\u5728\u5566");
            }
            scriptModel.setId(IdUtil.fastSimpleUUID());
            File file = scriptModel.getFile(true);
            if (file.exists() || file.isDirectory()) {
                return JsonMessage.getString((int)405, (String)"\u5f53\u5730id\u8def\u5f84\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\u6765\uff0c\u8bf7\u4fee\u6539");
            }
            this.scriptServer.addItem(scriptModel);
            return JsonMessage.getString((int)200, (String)"\u6dfb\u52a0\u6210\u529f");
        }
        if (eModel == null) {
            return JsonMessage.getString((int)405, (String)"\u5bf9\u5e94\u6570\u636e\u4e0d\u5b58\u5728");
        }
        eModel.setName(scriptModel.getName());
        eModel.setContext(scriptModel.getContext());
        this.scriptServer.updateItem(eModel);
        return JsonMessage.getString((int)200, (String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"del.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String del(String id) throws IOException {
        this.scriptServer.deleteItem(id);
        return JsonMessage.getString((int)200, (String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"upload.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String upload() throws IOException {
        MultipartFileBuilder multipartFileBuilder = this.createMultipart().addFieldName("file").setFileExt(new String[]{"bat", "sh"});
        multipartFileBuilder.setSavePath(AgentConfigBean.getInstance().getTempPathName());
        multipartFileBuilder.setUseOriginalFilename(true);
        String path = multipartFileBuilder.save();
        File file = FileUtil.file((String)path);
        String context = FileUtil.readString((String)path, (Charset)CharsetUtil.CHARSET_UTF_8);
        if (StrUtil.isEmpty((CharSequence)context)) {
            return JsonMessage.getString((int)405, (String)"\u811a\u672c\u5185\u5bb9\u4e3a\u7a7a");
        }
        String id = file.getName();
        ScriptModel eModel = this.scriptServer.getItem(id);
        if (eModel != null) {
            return JsonMessage.getString((int)405, (String)"\u5bf9\u5e94\u811a\u672c\u6a21\u677f\u5df2\u7ecf\u5b58\u5728\u5566");
        }
        eModel = new ScriptModel();
        eModel.setId(id);
        eModel.setName(id);
        eModel.setContext(context);
        file = eModel.getFile(true);
        if (file.exists() || file.isDirectory()) {
            return JsonMessage.getString((int)405, (String)"\u5f53\u5730id\u8def\u5f84\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\u6765\uff0c\u8bf7\u4fee\u6539");
        }
        this.scriptServer.addItem(eModel);
        return JsonMessage.getString((int)200, (String)"\u5bfc\u5165\u6210\u529f");
    }
}

