/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.monitor;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.PageUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.BaseAgentController;
import io.jpom.common.commander.AbstractProjectCommander;
import io.jpom.common.commander.AbstractSystemCommander;
import io.jpom.model.system.NetstatModel;
import io.jpom.model.system.ProcessModel;
import io.jpom.system.AgentConfigBean;
import io.jpom.util.CommandUtil;
import io.jpom.util.JvmUtil;
import java.io.File;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/"})
public class InternalController
extends BaseAgentController {
    @RequestMapping(value={"internal_data"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getInternal(String tag) throws Exception {
        int pid = AbstractProjectCommander.getInstance().getPid(tag);
        if (pid <= 0) {
            return JsonMessage.getString((int)400, (String)"");
        }
        JSONObject jsonObject = new JSONObject();
        ProcessModel item = AbstractSystemCommander.getInstance().getPidInfo(pid);
        jsonObject.put("process", (Object)item);
        JSONObject beanMem = this.getBeanMem(tag);
        jsonObject.put("beanMem", (Object)beanMem);
        List<NetstatModel> netstatModels = AbstractProjectCommander.getInstance().listNetstat(pid, false);
        jsonObject.put("netstat", netstatModels);
        return JsonMessage.getString((int)200, (String)"", (Object)jsonObject);
    }

    @RequestMapping(value={"threadInfos"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getThreadInfos(String tag) throws Exception {
        int length;
        int limit = this.getParameterInt("limit", 10);
        int page = this.getParameterInt("page", 1);
        ThreadMXBean bean = JvmUtil.getThreadMXBean((String)tag);
        if (bean == null) {
            return JsonMessage.getString((int)400, (String)"\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u4fe1\u606f");
        }
        bean.setThreadContentionMonitoringEnabled(true);
        ThreadInfo[] threadInfos = bean.dumpAllThreads(false, false);
        if (threadInfos == null || threadInfos.length <= 0) {
            return JsonMessage.getString((int)404, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u4efb\u4f55\u7ebf\u7a0b");
        }
        JSONArray array = new JSONArray();
        int index = PageUtil.getStart((int)page, (int)limit);
        int len = limit + index;
        if (len > (length = threadInfos.length)) {
            len = length;
        }
        for (int i = index; i < len; ++i) {
            ThreadInfo threadInfo = threadInfos[i];
            Thread.State threadState = threadInfo.getThreadState();
            JSONObject object = new JSONObject();
            object.put("id", (Object)threadInfo.getThreadId());
            object.put("name", (Object)threadInfo.getThreadName());
            object.put("status", (Object)threadState);
            object.put("waitedCount", (Object)threadInfo.getWaitedCount());
            object.put("waitedTime", (Object)threadInfo.getWaitedTime());
            object.put("blockedCount", (Object)threadInfo.getBlockedCount());
            object.put("blockedTime", (Object)threadInfo.getBlockedTime());
            object.put("isInNative", (Object)threadInfo.isInNative());
            object.put("isSuspended", (Object)threadInfo.isSuspended());
            array.add((Object)object);
        }
        JSONObject object = new JSONObject();
        object.put("count", (Object)length);
        object.put("data", (Object)array);
        return JsonMessage.getString((int)200, (String)"", (Object)object);
    }

    private JSONObject getBeanMem(String tag) {
        try {
            MemoryMXBean bean = JvmUtil.getMemoryMXBean((String)tag);
            if (bean == null) {
                return null;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("mount", (Object)bean.getObjectPendingFinalizationCount());
            MemoryUsage memory = bean.getHeapMemoryUsage();
            MemoryUsage nonHeapMemoryUsage = bean.getNonHeapMemoryUsage();
            long used = memory.getUsed();
            long max = memory.getMax();
            if (-1L == max) {
                max = memory.getCommitted();
            }
            double v = new BigDecimal(used).divide(new BigDecimal(max), 2, 4).doubleValue() * 100.0;
            jsonObject.put("heapUsed", (Object)FileUtil.readableFileSize((long)used));
            jsonObject.put("heapProportion", (Object)(String.format("%.2f", v) + "%"));
            jsonObject.put("heapCommitted", (Object)FileUtil.readableFileSize((long)memory.getCommitted()));
            long nonUsed = nonHeapMemoryUsage.getUsed();
            long nonMax = nonHeapMemoryUsage.getMax();
            long nonCommitted = nonHeapMemoryUsage.getCommitted();
            if (-1L == nonMax) {
                nonMax = nonCommitted;
            }
            jsonObject.put("nonHeapUsed", (Object)FileUtil.readableFileSize((long)nonUsed));
            double proportion = new BigDecimal(nonUsed).divide(new BigDecimal(nonMax), 2, 4).doubleValue() * 100.0;
            jsonObject.put("nonHeapProportion", (Object)(String.format("%.2f", proportion) + "%"));
            jsonObject.put("nonHeapCommitted", (Object)FileUtil.readableFileSize((long)nonCommitted));
            return jsonObject;
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"internal_stack"}, method={RequestMethod.GET})
    @ResponseBody
    public String stack(String tag) {
        String fileName = AgentConfigBean.getInstance().getTempPathName() + "/" + tag + "_java_cpu.txt";
        fileName = FileUtil.normalize((String)fileName);
        try {
            int pid = AbstractProjectCommander.getInstance().getPid(tag);
            if (pid <= 0) {
                return JsonMessage.getString((int)400, (String)"\u672a\u8fd0\u884c");
            }
            String command = String.format("jstack %s >> %s ", pid, fileName);
            CommandUtil.execSystemCommand((String)command);
            this.downLoad(this.getResponse(), fileName);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
        }
        return JsonMessage.getString((int)200, (String)"");
    }

    @RequestMapping(value={"internal_ram"}, method={RequestMethod.GET})
    @ResponseBody
    public String ram(String tag) {
        String fileName = AgentConfigBean.getInstance().getTempPathName() + "/" + tag + "_java_ram.txt";
        fileName = FileUtil.normalize((String)fileName);
        try {
            int pid = AbstractProjectCommander.getInstance().getPid(tag);
            if (pid <= 0) {
                return JsonMessage.getString((int)400, (String)"\u672a\u8fd0\u884c");
            }
            String command = String.format("jmap -histo:live %s >> %s", pid, fileName);
            CommandUtil.execSystemCommand((String)command);
            this.downLoad(this.getResponse(), fileName);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
        }
        return JsonMessage.getString((int)200, (String)"");
    }

    private void downLoad(HttpServletResponse response, String fileName) {
        File file = new File(fileName);
        ServletUtil.write((HttpServletResponse)response, (File)file);
        FileUtil.del((File)file);
    }
}

