/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.manage.log;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.BaseAgentController;
import io.jpom.common.commander.AbstractProjectCommander;
import io.jpom.model.data.ProjectInfoModel;
import io.jpom.util.FileUtils;
import java.io.File;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"manage/log"})
public class LogBackController
extends BaseAgentController {
    @RequestMapping(value={"logSize"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String logSize(String id) {
        ProjectInfoModel projectInfoModel = this.getProjectInfoModel();
        File logBack = projectInfoModel.getLogBack();
        JSONObject jsonObject = new JSONObject();
        boolean logBackBool = logBack.exists() && logBack.isDirectory();
        jsonObject.put("logBack", (Object)logBackBool);
        String info = this.projectInfoService.getLogSize(id);
        jsonObject.put("logSize", (Object)info);
        return JsonMessage.getString((int)200, (String)"", (Object)jsonObject);
    }

    @RequestMapping(value={"resetLog"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String resetLog() {
        ProjectInfoModel pim = this.getProjectInfoModel();
        try {
            String msg = AbstractProjectCommander.getInstance().backLog(pim);
            if (msg.contains("ok")) {
                return JsonMessage.getString((int)200, (String)"\u91cd\u7f6e\u6210\u529f");
            }
            return JsonMessage.getString((int)201, (String)("\u91cd\u7f6e\u5931\u8d25\uff1a" + msg));
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
            return JsonMessage.getString((int)500, (String)"\u91cd\u7f6e\u65e5\u5fd7\u5931\u8d25");
        }
    }

    @RequestMapping(value={"logBack_delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String clear(String name) {
        if (StrUtil.isEmpty((CharSequence)(name = LogBackController.pathSafe((String)name)))) {
            return JsonMessage.getString((int)405, (String)("\u975e\u6cd5\u64cd\u4f5c:" + name));
        }
        ProjectInfoModel pim = this.getProjectInfoModel();
        File logBack = pim.getLogBack();
        if (logBack.exists() && logBack.isDirectory()) {
            if ((logBack = FileUtil.file((File)logBack, (String)name)).exists()) {
                FileUtil.del((File)logBack);
                return JsonMessage.getString((int)200, (String)"\u5220\u9664\u6210\u529f");
            }
            return JsonMessage.getString((int)500, (String)"\u6ca1\u6709\u5bf9\u5e94\u6587\u4ef6");
        }
        return JsonMessage.getString((int)500, (String)"\u6ca1\u6709\u5bf9\u5e94\u6587\u4ef6\u5939");
    }

    @RequestMapping(value={"logBack_download"}, method={RequestMethod.GET})
    public String download(String key) {
        if (StrUtil.isEmpty((CharSequence)(key = LogBackController.pathSafe((String)key)))) {
            return JsonMessage.getString((int)405, (String)"\u975e\u6cd5\u64cd\u4f5c");
        }
        try {
            ProjectInfoModel pim = this.getProjectInfoModel();
            File logBack = pim.getLogBack();
            if (!logBack.exists() || !logBack.isDirectory()) {
                return "\u6ca1\u6709\u5bf9\u5e94\u6587\u4ef6";
            }
            logBack = FileUtil.file((File)logBack, (String)key);
            ServletUtil.write((HttpServletResponse)this.getResponse(), (File)logBack);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        return "\u4e0b\u8f7d\u5931\u8d25\u3002\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5";
    }

    @RequestMapping(value={"logBack"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String console() {
        File[] filesAll;
        ProjectInfoModel pim = this.getProjectInfoModel();
        JSONObject jsonObject = new JSONObject();
        File logBack = pim.getLogBack();
        if (logBack.exists() && logBack.isDirectory() && (filesAll = logBack.listFiles()) != null) {
            JSONArray jsonArray = FileUtils.parseInfo(filesAll, true, null);
            jsonObject.put("array", (Object)jsonArray);
        }
        jsonObject.put("id", (Object)pim.getId());
        jsonObject.put("logPath", (Object)pim.getLog());
        jsonObject.put("logBackPath", (Object)logBack.getAbsolutePath());
        return JsonMessage.getString((int)200, (String)"", (Object)jsonObject);
    }

    @RequestMapping(value={"export.html"}, method={RequestMethod.GET})
    @ResponseBody
    public String export() {
        ProjectInfoModel pim = this.getProjectInfoModel();
        File file = new File(pim.getLog());
        if (!file.exists()) {
            return JsonMessage.getString((int)400, (String)("\u6ca1\u6709\u65e5\u5fd7\u6587\u4ef6:" + file.getPath()));
        }
        HttpServletResponse response = this.getResponse();
        ServletUtil.write((HttpServletResponse)response, (File)file);
        return JsonMessage.getString((int)200, (String)"");
    }
}

