/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.manage;

import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import cn.jiangzeyin.common.validator.ValidatorConfig;
import cn.jiangzeyin.common.validator.ValidatorItem;
import cn.jiangzeyin.common.validator.ValidatorRule;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.BaseAgentController;
import io.jpom.common.commander.AbstractProjectCommander;
import io.jpom.model.data.ProjectInfoModel;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/"})
public class ProjectStatusController
extends BaseAgentController {
    @RequestMapping(value={"getProjectStatus"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getProjectStatus(@ValidatorConfig(value={@ValidatorItem(value=ValidatorRule.NOT_BLANK, msg="\u9879\u76eeid \u4e0d\u6b63\u786e")}) String id) {
        ProjectInfoModel projectInfoModel = this.tryGetProjectInfoModel();
        if (projectInfoModel == null) {
            return JsonMessage.getString((int)HttpStatus.NOT_FOUND.value(), (String)"\u9879\u76eeid\u4e0d\u5b58\u5728");
        }
        int pid = 0;
        try {
            pid = AbstractProjectCommander.getInstance().getPid(id);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u83b7\u53d6\u9879\u76eepid \u5931\u8d25", (Throwable)e);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("pId", (Object)pid);
        return JsonMessage.getString((int)200, (String)"", (Object)jsonObject);
    }

    @RequestMapping(value={"getProjectPort"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getProjectPort(String ids) {
        if (StrUtil.isEmpty((CharSequence)ids)) {
            return JsonMessage.getString((int)400, (String)"");
        }
        JSONArray jsonArray = JSONArray.parseArray((String)ids);
        JSONObject jsonObject = new JSONObject();
        for (Object object : jsonArray) {
            int pid;
            String item = object.toString();
            try {
                pid = AbstractProjectCommander.getInstance().getPid(item);
            }
            catch (Exception e) {
                DefaultSystemLog.ERROR().error("\u83b7\u53d6\u7aef\u53e3\u9519\u8bef", (Throwable)e);
                continue;
            }
            if (pid <= 0) continue;
            JSONObject itemObj = new JSONObject();
            String port = AbstractProjectCommander.getInstance().getMainPort(pid);
            itemObj.put("port", (Object)port);
            itemObj.put("pid", (Object)pid);
            jsonObject.put(item, (Object)itemObj);
        }
        return JsonMessage.getString((int)200, (String)"", (Object)jsonObject);
    }

    @RequestMapping(value={"restart"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String restart(@ValidatorConfig(value={@ValidatorItem(value=ValidatorRule.NOT_BLANK, msg="\u9879\u76eeid \u4e0d\u6b63\u786e")}) String id) {
        ProjectInfoModel item = (ProjectInfoModel)this.projectInfoService.getItem(id);
        if (item == null) {
            return JsonMessage.getString((int)405, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u9879\u76ee");
        }
        try {
            String result = AbstractProjectCommander.getInstance().restart(item);
            boolean status = AbstractProjectCommander.getInstance().isRun(item.getId());
            if (status) {
                return JsonMessage.getString((int)200, (String)result);
            }
            return JsonMessage.getString((int)201, (String)("\u91cd\u542f\u5931\u8d25\uff1a" + result));
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u83b7\u53d6\u9879\u76eepid \u5931\u8d25", (Throwable)e);
            String result = "error:" + e.getMessage();
            return JsonMessage.getString((int)500, (String)("\u91cd\u542f\u5f02\u5e38\uff1a" + result));
        }
    }
}

