/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.manage;

import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.BaseAgentController;
import io.jpom.common.commander.AbstractProjectCommander;
import io.jpom.model.data.ProjectInfoModel;
import java.util.HashSet;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/"})
public class ProjectListController
extends BaseAgentController {
    @RequestMapping(value={"getProjectItem"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getProjectItem(String id) {
        ProjectInfoModel projectInfoModel = (ProjectInfoModel)this.projectInfoService.getItem(id);
        if (projectInfoModel != null) {
            String command = AbstractProjectCommander.getInstance().buildCommand(projectInfoModel);
            projectInfoModel.setRunCommand(command);
        }
        return JsonMessage.getString((int)200, (String)"", (Object)((Object)projectInfoModel));
    }

    @RequestMapping(value={"getProjectGroup"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getProjectGroup() {
        HashSet<String> strings = this.projectInfoService.getAllGroup();
        return JsonMessage.getString((int)200, (String)"", strings);
    }

    @RequestMapping(value={"getProjectInfo"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getProjectInfo(String group, String notStatus) {
        try {
            boolean status = StrUtil.isEmpty((CharSequence)notStatus);
            List projectInfoModels = this.projectInfoService.list();
            JSONArray array = new JSONArray();
            for (ProjectInfoModel projectInfoModel : projectInfoModels) {
                if (StrUtil.isNotEmpty((CharSequence)group) && !group.equals(projectInfoModel.getGroup())) continue;
                JSONObject object = projectInfoModel.toJson();
                if (status) {
                    object.put("status", (Object)projectInfoModel.isStatus(true));
                }
                array.add((Object)object);
            }
            array.sort((oo1, oo2) -> {
                JSONObject o1 = (JSONObject)oo1;
                JSONObject o2 = (JSONObject)oo2;
                String group1 = o1.getString("group");
                String group2 = o2.getString("group");
                if (group1 == null || group2 == null) {
                    return -1;
                }
                return group1.compareTo(group2);
            });
            return JsonMessage.getString((int)200, (String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)array);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
            return JsonMessage.getString((int)500, (String)("\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }
}

