/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.manage;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import cn.jiangzeyin.controller.multipart.MultipartFileBuilder;
import com.alibaba.fastjson.JSONArray;
import io.jpom.common.BaseAgentController;
import io.jpom.model.data.ProjectInfoModel;
import io.jpom.service.manage.ConsoleService;
import io.jpom.socket.ConsoleCommandOp;
import io.jpom.system.AgentConfigBean;
import io.jpom.util.CompressionFileUtil;
import io.jpom.util.FileUtils;
import io.jpom.util.StringUtil;
import java.io.File;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/file/"})
public class ProjectFileControl
extends BaseAgentController {
    @Resource
    private ConsoleService consoleService;

    @RequestMapping(value={"getFileList"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String getFileList(String id, String path) {
        ProjectInfoModel pim = (ProjectInfoModel)this.projectInfoService.getItem(id);
        if (pim == null) {
            return JsonMessage.getString((int)500, (String)"\u67e5\u8be2\u5931\u8d25\uff1a\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        String lib = pim.allLib();
        File fileDir = !StrUtil.isEmptyOrUndefined((CharSequence)path) ? FileUtil.file((String)lib, (String)path) : new File(lib);
        if (!fileDir.exists()) {
            return JsonMessage.getString((int)500, (String)"\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        File[] filesAll = fileDir.listFiles();
        if (filesAll == null) {
            return JsonMessage.getString((int)500, (String)"\u76ee\u5f55\u662f\u7a7a");
        }
        JSONArray arrayFile = FileUtils.parseInfo(filesAll, false, lib);
        return JsonMessage.getString((int)200, (String)"\u67e5\u8be2\u6210\u529f", (Object)arrayFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"upload"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String upload() throws Exception {
        ProjectInfoModel pim;
        block8: {
            pim = this.getProjectInfoModel();
            MultipartFileBuilder multipartFileBuilder = this.createMultipart().addFieldName("file");
            String type = this.getParameter("type");
            String clearType = this.getParameter("clearType");
            String levelName = this.getParameter("levelName");
            File lib = StrUtil.isEmpty((CharSequence)levelName) ? new File(pim.allLib()) : FileUtil.file((String)pim.allLib(), (String)levelName);
            if ("unzip".equals(type)) {
                multipartFileBuilder.setFileExt(StringUtil.PACKAGE_EXT);
                multipartFileBuilder.setSavePath(AgentConfigBean.getInstance().getTempPathName());
                String path = multipartFileBuilder.save();
                if ("clear".equalsIgnoreCase(clearType) && !FileUtil.clean((File)lib)) {
                    return JsonMessage.getString((int)500, (String)"\u6e05\u9664\u65e7lib\u5931\u8d25");
                }
                File file = new File(path);
                try {
                    List<String> names = CompressionFileUtil.unCompress(file, lib);
                    if (names == null || names.isEmpty()) {
                        String string = JsonMessage.getString((int)500, (String)"\u6ca1\u6709\u89e3\u538b\u51fa\u4efb\u4f55\u6587\u4ef6");
                        return string;
                    }
                    break block8;
                }
                finally {
                    if (!file.delete()) {
                        DefaultSystemLog.LOG().info("\u5220\u9664\u5931\u8d25\uff1a" + file.getPath());
                    }
                }
            }
            multipartFileBuilder.setSavePath(FileUtil.getAbsolutePath((File)lib)).setUseOriginalFilename(true);
            multipartFileBuilder.save();
        }
        pim.setUseLibDesc("upload");
        this.projectInfoService.updateItem(pim);
        String after = this.getParameter("after");
        if ("restart".equalsIgnoreCase(after)) {
            String result = this.consoleService.execCommand(ConsoleCommandOp.restart, pim);
            return JsonMessage.getString((int)200, (String)("\u4e0a\u4f20\u6210\u529f\u5e76\u91cd\u542f\uff1a" + result));
        }
        return JsonMessage.getString((int)200, (String)"\u4e0a\u4f20\u6210\u529f");
    }

    @RequestMapping(value={"deleteFile"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String deleteFile(String filename, String type, String levelName) {
        ProjectInfoModel pim = this.getProjectInfoModel();
        if ("clear".equalsIgnoreCase(type)) {
            File file = new File(pim.allLib());
            if (FileUtil.clean((File)file)) {
                return JsonMessage.getString((int)200, (String)"\u6e05\u9664\u6210\u529f");
            }
            if (pim.isStatus(true)) {
                return JsonMessage.getString((int)501, (String)"\u6587\u4ef6\u88ab\u5360\u7528\uff0c\u8bf7\u5148\u505c\u6b62\u9879\u76ee");
            }
            return JsonMessage.getString((int)500, (String)("\u5220\u9664\u5931\u8d25\uff1a" + file.getAbsolutePath()));
        }
        String fileName = ProjectFileControl.pathSafe((String)filename);
        if (StrUtil.isEmpty((CharSequence)fileName)) {
            return JsonMessage.getString((int)405, (String)"\u975e\u6cd5\u64cd\u4f5c");
        }
        File file = StrUtil.isEmpty((CharSequence)levelName) ? FileUtil.file((String)pim.allLib(), (String)fileName) : FileUtil.file((String[])new String[]{pim.allLib(), levelName, fileName});
        if (file.exists()) {
            if (FileUtil.del((File)file)) {
                return JsonMessage.getString((int)200, (String)"\u5220\u9664\u6210\u529f");
            }
        } else {
            return JsonMessage.getString((int)404, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return JsonMessage.getString((int)500, (String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"download"}, method={RequestMethod.GET})
    public String download(String id, String filename, String levelName) {
        String safeFileName = ProjectFileControl.pathSafe((String)filename);
        if (StrUtil.isEmpty((CharSequence)safeFileName)) {
            return JsonMessage.getString((int)405, (String)"\u975e\u6cd5\u64cd\u4f5c");
        }
        try {
            ProjectInfoModel pim = (ProjectInfoModel)this.projectInfoService.getItem(id);
            File file = StrUtil.isEmpty((CharSequence)levelName) ? FileUtil.file((String)pim.allLib(), (String)filename) : FileUtil.file((String[])new String[]{pim.allLib(), levelName, filename});
            if (file.isDirectory()) {
                return "\u6682\u4e0d\u652f\u6301\u4e0b\u8f7d\u6587\u4ef6\u5939";
            }
            ServletUtil.write((HttpServletResponse)this.getResponse(), (File)file);
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        return "\u4e0b\u8f7d\u5931\u8d25\u3002\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5";
    }
}

