/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller.manage;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.JsonMessage;
import io.jpom.common.BaseAgentController;
import io.jpom.common.commander.AbstractProjectCommander;
import io.jpom.model.RunMode;
import io.jpom.model.data.ProjectInfoModel;
import io.jpom.service.WhitelistDirectoryService;
import io.jpom.system.ConfigBean;
import io.jpom.util.StringUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/"})
public class EditProjectController
extends BaseAgentController {
    @Resource
    private WhitelistDirectoryService whitelistDirectoryService;

    private String checkParameter(ProjectInfoModel projectInfo, String whitelistDirectory, boolean previewData) {
        String lib;
        String id = projectInfo.getId();
        if (StrUtil.isEmptyOrUndefined((CharSequence)id)) {
            return JsonMessage.getString((int)400, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtil.isGeneral((CharSequence)id, (int)2, (int)20)) {
            return JsonMessage.getString((int)401, (String)"\u9879\u76eeid \u957f\u5ea6\u8303\u56f42-20\uff08\u82f1\u6587\u5b57\u6bcd \u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\uff09");
        }
        if ("system".equals(id)) {
            return JsonMessage.getString((int)401, (String)"\u9879\u76eeid system \u5173\u952e\u8bcd\u88ab\u7cfb\u7edf\u5360\u7528");
        }
        if (StrUtil.isNotEmpty((CharSequence)ConfigBean.getInstance().applicationTag) && ConfigBean.getInstance().applicationTag.equalsIgnoreCase(id)) {
            return JsonMessage.getString((int)401, (String)"\u5f53\u524d\u9879\u76eeid\u5df2\u7ecf\u88abJpom\u5360\u7528");
        }
        String runMode = this.getParameter("runMode");
        RunMode runMode1 = RunMode.ClassPath;
        try {
            runMode1 = RunMode.valueOf((String)runMode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        projectInfo.setRunMode(runMode1);
        if (runMode1 == RunMode.ClassPath) {
            if (StrUtil.isEmpty((CharSequence)projectInfo.getMainClass())) {
                return JsonMessage.getString((int)401, (String)"ClassPath \u6a21\u5f0f MainClass\u5fc5\u586b");
            }
        } else if (runMode1 == RunMode.Jar) {
            projectInfo.setMainClass("");
        }
        String strOutGivingProject = this.getParameter("outGivingProject");
        boolean outGivingProject = Boolean.parseBoolean(strOutGivingProject);
        projectInfo.setOutGivingProject(outGivingProject);
        if (!previewData && !this.whitelistDirectoryService.checkProjectDirectory(whitelistDirectory)) {
            if (outGivingProject) {
                this.whitelistDirectoryService.addProjectWhiteList(whitelistDirectory);
            } else {
                return JsonMessage.getString((int)401, (String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u9879\u76ee\u8def\u5f84,\u6216\u8005\u8fd8\u6ca1\u6709\u914d\u7f6e\u767d\u540d\u5355");
            }
        }
        if (StrUtil.isEmpty((CharSequence)(lib = projectInfo.getLib())) || "/".equals(lib) || Validator.isChinese((CharSequence)lib)) {
            return JsonMessage.getString((int)401, (String)"\u9879\u76eeJar\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a,\u4e0d\u80fd\u4e3a\u9876\u7ea7\u76ee\u5f55,\u4e0d\u80fd\u5305\u542b\u4e2d\u6587");
        }
        if (!this.checkPathSafe(lib)) {
            return JsonMessage.getString((int)401, (String)"\u9879\u76eeJar\u8def\u5f84\u5b58\u5728\u63d0\u5347\u76ee\u5f55\u95ee\u9898");
        }
        return null;
    }

    @RequestMapping(value={"saveProject"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String saveProject(ProjectInfoModel projectInfo) {
        File checkFile;
        String strPreviewData = this.getParameter("previewData");
        boolean previewData = Convert.toBool((Object)strPreviewData, (Boolean)false);
        String whitelistDirectory = projectInfo.getWhitelistDirectory();
        String error = this.checkParameter(projectInfo, whitelistDirectory, previewData);
        if (error != null) {
            return error;
        }
        String id = projectInfo.getId();
        String allLib = projectInfo.allLib();
        List list = this.projectInfoService.list();
        if (list != null) {
            for (ProjectInfoModel projectInfoModel : list) {
                if (projectInfoModel.getId().equals(id) || !projectInfoModel.allLib().equals(allLib)) continue;
                return JsonMessage.getString((int)401, (String)("\u5f53\u524d\u9879\u76eeJar\u8def\u5f84\u5df2\u7ecf\u88ab\u3010" + projectInfoModel.getName() + "\u3011\u5360\u7528,\u8bf7\u68c0\u67e5"));
            }
        }
        if ((checkFile = new File(allLib)).exists() && checkFile.isFile()) {
            return JsonMessage.getString((int)401, (String)"\u9879\u76eeJar\u8def\u5f84\u662f\u4e00\u4e2a\u5df2\u7ecf\u5b58\u5728\u7684\u6587\u4ef6");
        }
        String log = new File(allLib).getParent();
        log = String.format("%s/%s.log", log, id);
        projectInfo.setLog(FileUtil.normalize((String)log));
        checkFile = new File(projectInfo.getLog());
        if (checkFile.exists() && checkFile.isDirectory()) {
            return JsonMessage.getString((int)401, (String)"\u9879\u76eelog\u662f\u4e00\u4e2a\u5df2\u7ecf\u5b58\u5728\u7684\u6587\u4ef6\u5939");
        }
        String token = projectInfo.getToken();
        if (StrUtil.isNotEmpty((CharSequence)token) && !ReUtil.isMatch((Pattern)PatternPool.URL_HTTP, (CharSequence)token)) {
            return JsonMessage.getString((int)401, (String)"WebHooks \u5730\u5740\u4e0d\u5408\u6cd5");
        }
        if (id.contains(" ") || allLib.contains(" ")) {
            return JsonMessage.getString((int)401, (String)"\u9879\u76eeId\u3001\u9879\u76eeJar\u4e0d\u80fd\u5305\u542b\u7a7a\u683c");
        }
        return this.save(projectInfo, previewData);
    }

    private String save(ProjectInfoModel projectInfo, boolean previewData) {
        String edit = this.getParameter("edit");
        ProjectInfoModel exits = (ProjectInfoModel)this.projectInfoService.getItem(projectInfo.getId());
        try {
            JsonMessage jsonMessage = this.checkPath(projectInfo);
            if (jsonMessage != null) {
                return jsonMessage.toString();
            }
            if (exits == null) {
                if (AbstractProjectCommander.getInstance().isRun(projectInfo.getId())) {
                    return JsonMessage.getString((int)400, (String)"\u5f53\u524d\u9879\u76eeid\u5df2\u7ecf\u88ab\u6b63\u5728\u8fd0\u884c\u7684\u7a0b\u5e8f\u5360\u7528");
                }
                if (previewData) {
                    return JsonMessage.getString((int)200, (String)"");
                }
                projectInfo.setCreateTime(DateUtil.now());
                this.modify(projectInfo);
                this.projectInfoService.addItem(projectInfo);
                return JsonMessage.getString((int)200, (String)"\u65b0\u589e\u6210\u529f\uff01");
            }
            if (!"on".equalsIgnoreCase(edit)) {
                return JsonMessage.getString((int)400, (String)"\u9879\u76eeid\u5df2\u7ecf\u5b58\u5728\u5566");
            }
            if (previewData) {
                return JsonMessage.getString((int)200, (String)"");
            }
            this.modify(exits);
            exits.setLog(projectInfo.getLog());
            exits.setName(projectInfo.getName());
            exits.setGroup(projectInfo.getGroup());
            exits.setMainClass(projectInfo.getMainClass());
            exits.setLib(projectInfo.getLib());
            exits.setJvm(projectInfo.getJvm());
            exits.setArgs(projectInfo.getArgs());
            exits.setRunMode(projectInfo.getRunMode());
            exits.setWhitelistDirectory(projectInfo.getWhitelistDirectory());
            exits.setToken(projectInfo.getToken());
            this.moveTo(exits, projectInfo);
            this.projectInfoService.updateItem(exits);
            return JsonMessage.getString((int)200, (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
            return JsonMessage.getString((int)500, (String)"\u4fdd\u5b58\u6570\u636e\u5f02\u5e38");
        }
    }

    private void modify(ProjectInfoModel exits) {
        exits.setModifyUser(this.getUserName());
    }

    private void moveTo(ProjectInfoModel old, ProjectInfoModel news) {
        File oldLib;
        if (!old.allLib().equals(news.allLib()) && (oldLib = new File(old.allLib())).exists()) {
            File newsLib = new File(news.allLib());
            FileUtil.move((File)oldLib, (File)newsLib, (boolean)true);
        }
        if (!old.getLog().equals(news.getLog())) {
            File oldLogBack;
            File oldLog = new File(old.getLog());
            if (oldLog.exists()) {
                File newsLog = new File(news.getLog());
                FileUtil.move((File)oldLog, (File)newsLog, (boolean)true);
            }
            if ((oldLogBack = old.getLogBack()).exists()) {
                FileUtil.move((File)oldLogBack, (File)news.getLogBack(), (boolean)true);
            }
        }
    }

    private JsonMessage checkPath(ProjectInfoModel projectInfoModel) {
        List projectInfoModelList = this.projectInfoService.list();
        if (projectInfoModelList == null) {
            return null;
        }
        ProjectInfoModel projectInfoModel1 = null;
        for (ProjectInfoModel model : projectInfoModelList) {
            File file2;
            if (model.getId().equals(projectInfoModel.getId())) continue;
            File file1 = new File(model.allLib());
            if (FileUtil.pathEquals((File)file1, (File)(file2 = new File(projectInfoModel.allLib())))) {
                projectInfoModel1 = model;
                break;
            }
            if (!FileUtil.isSub((File)file1, (File)file2) && !FileUtil.isSub((File)file2, (File)file1)) continue;
            projectInfoModel1 = model;
            break;
        }
        if (projectInfoModel1 != null) {
            return new JsonMessage(401, "\u9879\u76eeJar\u8def\u5f84\u548c\u3010" + projectInfoModel1.getName() + "\u3011\u9879\u76ee\u51b2\u7a81:" + projectInfoModel1.allLib());
        }
        return null;
    }

    @RequestMapping(value={"deleteProject"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String deleteProject() {
        ProjectInfoModel projectInfoModel = this.tryGetProjectInfoModel();
        if (projectInfoModel == null) {
            return JsonMessage.getString((int)200, (String)"\u9879\u76ee\u4e0d\u5b58\u5728");
        }
        try {
            if (projectInfoModel.isStatus(true)) {
                return JsonMessage.getString((int)401, (String)"\u4e0d\u80fd\u5220\u9664\u6b63\u5728\u8fd0\u884c\u7684\u9879\u76ee");
            }
            this.projectInfoService.deleteItem(projectInfoModel.getId());
            return JsonMessage.getString((int)200, (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error(e.getMessage(), (Throwable)e);
            return JsonMessage.getString((int)500, (String)("\u5220\u9664\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"releaseOutGiving"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String releaseOutGiving() throws Exception {
        ProjectInfoModel projectInfoModel = this.tryGetProjectInfoModel();
        if (projectInfoModel != null) {
            projectInfoModel.setOutGivingProject(false);
            this.projectInfoService.updateItem(projectInfoModel);
        }
        return JsonMessage.getString((int)200, (String)"ok");
    }

    @RequestMapping(value={"judge_lib.json"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String saveProject(String id, String newLib) {
        File file = new File(newLib);
        if (file.exists() && file.isFile()) {
            return JsonMessage.getString((int)400, (String)"\u586b\u5199jar\u76ee\u5f55\u5f53\u524d\u662f\u4e00\u4e2a\u5df2\u7ecf\u5b58\u5728\u7684\u6587\u4ef6,\u8bf7\u4fee\u6539");
        }
        ProjectInfoModel exits = (ProjectInfoModel)this.projectInfoService.getItem(id);
        if (exits == null) {
            if (file.exists()) {
                return JsonMessage.getString((int)401, (String)"\u586b\u5199jar\u76ee\u5f55\u5f53\u524d\u5df2\u7ecf\u5728,\u521b\u5efa\u6210\u529f\u540e\u4f1a\u81ea\u52a8\u540c\u6b65\u6587\u4ef6");
            }
        } else {
            Path oldPath;
            File oldLib = new File(exits.allLib());
            Path newPath = file.toPath();
            if (newPath.equals(oldPath = oldLib.toPath())) {
                return JsonMessage.getString((int)200, (String)"");
            }
            if (file.exists()) {
                if (oldLib.exists()) {
                    return JsonMessage.getString((int)401, (String)"\u539fjar\u76ee\u5f55\u5df2\u7ecf\u5b58\u5728\u5e76\u4e14\u65b0\u7684jar\u76ee\u5f55\u5df2\u7ecf\u5b58\u5728,\u4fdd\u5b58\u5c06\u8986\u76d6\u65b0\u6587\u4ef6\u5939\u5e76\u4f1a\u81ea\u52a8\u540c\u6b65\u539fjar\u76ee\u5f55");
                }
                return JsonMessage.getString((int)401, (String)"\u586b\u5199jar\u76ee\u5f55\u5f53\u524d\u5df2\u7ecf\u5728,\u521b\u5efa\u6210\u529f\u540e\u4f1a\u81ea\u52a8\u540c\u6b65\u6587\u4ef6");
            }
        }
        if (Validator.isChinese((CharSequence)newLib)) {
            return JsonMessage.getString((int)401, (String)"\u4e0d\u5efa\u8bae\u4f7f\u7528\u4e2d\u6587\u76ee\u5f55");
        }
        return JsonMessage.getString((int)200, (String)"");
    }
}

