/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.controller;

import cn.hutool.system.SystemUtil;
import cn.jiangzeyin.common.JsonMessage;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.BaseAgentController;
import io.jpom.common.JpomManifest;
import io.jpom.common.interceptor.NotAuthorize;
import io.jpom.service.WhitelistDirectoryService;
import io.jpom.service.manage.ProjectInfoService;
import io.jpom.util.JvmUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IndexController
extends BaseAgentController {
    @Resource
    private WhitelistDirectoryService whitelistDirectoryService;
    @Resource
    private ProjectInfoService projectInfoService;

    @RequestMapping(value={"index", "", "index.html", "/"}, produces={"text/plain"})
    @NotAuthorize
    public String index() {
        return "Jpom-Agent";
    }

    @RequestMapping(value={"info"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String info() {
        int code = this.whitelistDirectoryService.isInstalled() ? 200 : 201;
        return JsonMessage.getString((int)code, (String)"", (Object)JpomManifest.getInstance());
    }

    @RequestMapping(value={"status"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String status() {
        List projectInfoModels = this.projectInfoService.list();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("javaVirtualCount", (Object)JvmUtil.getJavaVirtualCount());
        jsonObject.put("osName", (Object)SystemUtil.getOsInfo().getName());
        jsonObject.put("jpomVersion", (Object)JpomManifest.getInstance().getVersion());
        jsonObject.put("javaVersion", (Object)SystemUtil.getJavaRuntimeInfo().getVersion());
        int count = 0;
        if (projectInfoModels != null) {
            count = projectInfoModels.size();
        }
        jsonObject.put("count", (Object)count);
        jsonObject.put("runTime", (Object)JpomManifest.getInstance().getUpTime());
        return JsonMessage.getString((int)200, (String)"", (Object)jsonObject);
    }
}

