/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common.commander.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.sun.management.OperatingSystemMXBean;
import io.jpom.common.commander.AbstractSystemCommander;
import io.jpom.model.system.ProcessModel;
import io.jpom.util.CommandUtil;
import io.jpom.util.JvmUtil;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class WindowsSystemCommander
extends AbstractSystemCommander {
    private static final AtomicBoolean ATOMIC_BOOLEAN = new AtomicBoolean(false);
    private static List<ProcessModel> lastResult;

    @Override
    public JSONObject getAllMonitor() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("top", (Object)true);
        double total = operatingSystemMXBean.getTotalPhysicalMemorySize();
        double free = operatingSystemMXBean.getFreePhysicalMemorySize();
        jsonObject.put("memory", (Object)String.format("%.2f", (total - free) / total * 100.0));
        double systemCpuLoad = operatingSystemMXBean.getSystemCpuLoad();
        if (systemCpuLoad <= 0.0) {
            systemCpuLoad = 0.0;
        }
        jsonObject.put("cpu", (Object)String.format("%.2f", systemCpuLoad * 100.0));
        jsonObject.put("disk", (Object)WindowsSystemCommander.getHardDisk());
        return jsonObject;
    }

    @Override
    public List<ProcessModel> getProcessList() {
        if (ATOMIC_BOOLEAN.get()) {
            return lastResult;
        }
        try {
            ATOMIC_BOOLEAN.set(true);
            String s = CommandUtil.execSystemCommand((String)"tasklist /V | findstr java");
            List<ProcessModel> list = lastResult = WindowsSystemCommander.formatWindowsProcess(s, false);
            return list;
        }
        finally {
            ATOMIC_BOOLEAN.set(false);
        }
    }

    @Override
    public ProcessModel getPidInfo(int pid) {
        String command = "tasklist /V /FI \"pid eq " + pid + "\"";
        String result = CommandUtil.execCommand((String)command);
        List<ProcessModel> array = WindowsSystemCommander.formatWindowsProcess(result, true);
        if (array == null || array.isEmpty()) {
            return null;
        }
        return array.get(0);
    }

    private static List<ProcessModel> formatWindowsProcess(String result, boolean header) {
        List list = StrSpliter.splitTrim((String)result, (String)"\n", (boolean)true);
        if (list.isEmpty()) {
            return null;
        }
        ArrayList<ProcessModel> processModels = new ArrayList<ProcessModel>();
        int len = list.size();
        for (int i = header ? 2 : 0; i < len; ++i) {
            String param = (String)list.get(i);
            List memList = StrSpliter.splitTrim((String)param, (String)" ", (boolean)true);
            ProcessModel processModel = new ProcessModel();
            int pid = Convert.toInt(memList.get(1), (Integer)0);
            processModel.setPid(pid);
            String name = (String)memList.get(0);
            processModel.setCommand(name);
            String mem = ((String)memList.get(4)).replace(",", "");
            long aLong = Convert.toLong((Object)mem, (Long)0L);
            processModel.setRes(aLong / 1024L + " MB");
            String status = (String)memList.get(6);
            processModel.setStatus(WindowsSystemCommander.formatStatus(status));
            processModel.setUser((String)memList.get(7));
            processModel.setTime((String)memList.get(8));
            try {
                OperatingSystemMXBean operatingSystemMXBean = JvmUtil.getOperatingSystemMXBean((String)((String)memList.get(1)));
                if (operatingSystemMXBean != null) {
                    double processCpuLoad = operatingSystemMXBean.getProcessCpuLoad() * 100.0;
                    if (processCpuLoad <= 0.0) {
                        processCpuLoad = 0.0;
                    }
                    processModel.setCpu(String.format("%.2f", processCpuLoad) + "%");
                    long totalMemorySize = operatingSystemMXBean.getTotalPhysicalMemorySize();
                    BigDecimal total = new BigDecimal(totalMemorySize / 1024L);
                    double v = new BigDecimal(aLong).divide(total, 4, 4).doubleValue() * 100.0;
                    processModel.setMem(String.format("%.2f", v) + "%");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            processModels.add(processModel);
        }
        return processModels;
    }

    private static String formatStatus(String status) {
        if ("RUNNING".equalsIgnoreCase(status)) {
            return "\u8fd0\u884c";
        }
        if ("SUSPENDED".equalsIgnoreCase(status)) {
            return "\u7761\u7720";
        }
        if ("NOT RESPONDING".equalsIgnoreCase(status)) {
            return "\u65e0\u54cd\u5e94";
        }
        if ("Unknown".equalsIgnoreCase(status)) {
            return "\u672a\u77e5";
        }
        return status;
    }

    @Override
    public boolean getServiceStatus(String serviceName) {
        String result = CommandUtil.execSystemCommand((String)("sc query " + serviceName));
        return StrUtil.containsIgnoreCase((CharSequence)result, (CharSequence)"RUNNING");
    }

    @Override
    public String startService(String serviceName) {
        String format = StrUtil.format((CharSequence)"net start {}", (Object[])new Object[]{serviceName});
        return CommandUtil.execSystemCommand((String)format);
    }

    @Override
    public String stopService(String serviceName) {
        String format = StrUtil.format((CharSequence)"net stop {}", (Object[])new Object[]{serviceName});
        return CommandUtil.execSystemCommand((String)format);
    }
}

