/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common.commander.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.StrUtil;
import io.jpom.common.commander.AbstractProjectCommander;
import io.jpom.model.data.ProjectInfoModel;
import io.jpom.model.system.NetstatModel;
import io.jpom.util.CommandUtil;
import io.jpom.util.JvmUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WindowsProjectCommander
extends AbstractProjectCommander {
    @Override
    public String buildCommand(ProjectInfoModel projectInfoModel) {
        String classPath = ProjectInfoModel.getClassPathLib(projectInfoModel);
        if (StrUtil.isBlank((CharSequence)classPath)) {
            return null;
        }
        String jvm = projectInfoModel.getJvm();
        String tag = projectInfoModel.getId();
        String mainClass = projectInfoModel.getMainClass();
        String args = projectInfoModel.getArgs();
        return String.format("javaw %s %s %s  %s  %s >> %s &", jvm, JvmUtil.getJpomPidTag((String)tag, (String)projectInfoModel.allLib()), classPath, mainClass, args, projectInfoModel.getAbsoluteLog());
    }

    @Override
    public String stop(ProjectInfoModel projectInfoModel) throws Exception {
        String result = super.stop(projectInfoModel);
        String tag = projectInfoModel.getId();
        int pid = WindowsProjectCommander.parsePid(result);
        if (pid > 0) {
            String cmd = String.format("taskkill /F /PID %s", pid);
            CommandUtil.asyncExeLocalCommand((File)FileUtil.file((String)projectInfoModel.allLib()), (String)cmd);
            this.loopCheckRun(projectInfoModel.getId(), false);
            result = this.status(tag);
        }
        return result;
    }

    @Override
    public List<NetstatModel> listNetstat(int pId, boolean listening) {
        String cmd = listening ? "netstat -nao -p tcp | findstr \"LISTENING\" | findstr " + pId : "netstat -nao -p tcp | findstr /V \"CLOSE_WAIT\" | findstr " + pId;
        String result = CommandUtil.execSystemCommand((String)cmd);
        List netList = StrSpliter.splitTrim((String)result, (String)"\n", (boolean)true);
        if (netList == null || netList.size() <= 0) {
            return null;
        }
        ArrayList<NetstatModel> array = new ArrayList<NetstatModel>();
        for (String str : netList) {
            List list = StrSpliter.splitTrim((String)str, (String)" ", (boolean)true);
            if (list.size() < 5) continue;
            NetstatModel netstatModel = new NetstatModel();
            netstatModel.setProtocol((String)list.get(0));
            netstatModel.setLocal((String)list.get(1));
            netstatModel.setForeign((String)list.get(2));
            netstatModel.setStatus((String)list.get(3));
            netstatModel.setName((String)list.get(4));
            array.add(netstatModel);
        }
        return array;
    }
}

