/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common.commander.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.commander.AbstractSystemCommander;
import io.jpom.model.system.ProcessModel;
import io.jpom.util.CommandUtil;
import java.util.ArrayList;
import java.util.List;

public class LinuxSystemCommander
extends AbstractSystemCommander {
    @Override
    public JSONObject getAllMonitor() {
        String result = CommandUtil.execCommand((String)"top -b -n 1");
        if (StrUtil.isEmpty((CharSequence)result)) {
            return null;
        }
        String[] split = result.split("\n");
        int length = split.length;
        JSONObject jsonObject = new JSONObject();
        if (length >= 2) {
            String cpus = split[2];
            String cpu = LinuxSystemCommander.getLinuxCpu(cpus);
            jsonObject.put("cpu", (Object)cpu);
        }
        if (length >= 3) {
            String mem = split[3];
            String memory = LinuxSystemCommander.getLinuxMemory(mem);
            jsonObject.put("memory", (Object)memory);
        }
        jsonObject.put("top", (Object)true);
        jsonObject.put("disk", (Object)LinuxSystemCommander.getHardDisk());
        return jsonObject;
    }

    @Override
    public List<ProcessModel> getProcessList() {
        String s = CommandUtil.execSystemCommand((String)"top -b -n 1 | grep java");
        return LinuxSystemCommander.formatLinuxTop(s, false);
    }

    @Override
    public ProcessModel getPidInfo(int pid) {
        String command = "top -b -n 1 -p " + pid;
        String internal = CommandUtil.execCommand((String)command);
        List<ProcessModel> processModels = LinuxSystemCommander.formatLinuxTop(internal, true);
        if (processModels == null || processModels.isEmpty()) {
            return null;
        }
        return processModels.get(0);
    }

    private static List<ProcessModel> formatLinuxTop(String top, boolean header) {
        List list = StrSpliter.splitTrim((String)top, (String)"\n", (boolean)true);
        if (list.size() <= 0) {
            return null;
        }
        ArrayList<ProcessModel> list1 = new ArrayList<ProcessModel>();
        int len = list.size();
        for (int i = header ? 6 : 0; i < len; ++i) {
            ProcessModel processModel = new ProcessModel();
            String item = (String)list.get(i);
            List values = StrSpliter.splitTrim((String)item, (String)" ", (boolean)true);
            processModel.setPid(Integer.parseInt((String)values.get(0)));
            processModel.setUser((String)values.get(1));
            processModel.setPr((String)values.get(2));
            processModel.setNi((String)values.get(3));
            processModel.setVirt(LinuxSystemCommander.formSize((String)values.get(4)));
            processModel.setRes(LinuxSystemCommander.formSize((String)values.get(5)));
            processModel.setShr(LinuxSystemCommander.formSize((String)values.get(6)));
            processModel.setStatus(LinuxSystemCommander.formStatus((String)values.get(7)));
            processModel.setCpu((String)values.get(8) + "%");
            processModel.setMem((String)values.get(9) + "%");
            processModel.setTime((String)values.get(10));
            processModel.setCommand((String)values.get(11));
            list1.add(processModel);
        }
        return list1;
    }

    private static String formStatus(String val) {
        String value = "\u672a\u77e5";
        if ("S".equalsIgnoreCase(val)) {
            value = "\u7761\u7720";
        } else if ("R".equalsIgnoreCase(val)) {
            value = "\u8fd0\u884c";
        } else if ("T".equalsIgnoreCase(val)) {
            value = "\u8ddf\u8e2a/\u505c\u6b62";
        } else if ("Z".equalsIgnoreCase(val)) {
            value = "\u50f5\u5c38\u8fdb\u7a0b ";
        } else if ("D".equalsIgnoreCase(val)) {
            value = "\u4e0d\u53ef\u4e2d\u65ad\u7684\u7761\u7720\u72b6\u6001 ";
        } else if ("i".equalsIgnoreCase(val)) {
            value = "\u591a\u7ebf\u7a0b ";
        }
        return value;
    }

    private static String formSize(String val) {
        if (StrUtil.endWithIgnoreCase((CharSequence)val, (CharSequence)"g")) {
            String newVal = val.substring(0, val.length() - 1);
            return String.format("%.2f MB", Convert.toDouble((Object)newVal, (Double)0.0) * 1024.0);
        }
        if (StrUtil.endWithIgnoreCase((CharSequence)val, (CharSequence)"m")) {
            String newVal = val.substring(0, val.length() - 1);
            return Convert.toLong((Object)newVal, (Long)0L) / 1024L + " MB";
        }
        return Convert.toLong((Object)val, (Long)0L) / 1024L + " MB";
    }

    private static String getLinuxMemory(String info) {
        if (StrUtil.isEmpty((CharSequence)info)) {
            return null;
        }
        int index = info.indexOf(":") + 1;
        String[] split = info.substring(index).split(",");
        double total = 0.0;
        double used = 0.0;
        for (String str : split) {
            String value;
            if ((str = str.trim()).endsWith("used")) {
                value = str.replace("used", "").replace("k", "").trim();
                used = Convert.toDouble((Object)value, (Double)0.0);
            }
            if (!str.endsWith("total")) continue;
            value = str.replace("total", "").replace("k", "").trim();
            total = Convert.toDouble((Object)value, (Double)0.0);
        }
        return String.format("%.2f", used / total * 100.0);
    }

    private static String getLinuxCpu(String info) {
        String[] split;
        if (StrUtil.isEmpty((CharSequence)info)) {
            return null;
        }
        int i = info.indexOf(":");
        for (String str : split = info.substring(i + 1).split(",")) {
            str = str.trim();
            String value = str.substring(0, str.length() - 2).trim();
            String tag = str.substring(str.length() - 2);
            if (!"id".equalsIgnoreCase(tag)) continue;
            value = value.replace("%", "");
            double val = Convert.toDouble((Object)value, (Double)0.0);
            return String.format("%.2f", 100.0 - val);
        }
        return "0";
    }

    @Override
    public boolean getServiceStatus(String serviceName) {
        String format = StrUtil.format((CharSequence)"service {} status", (Object[])new Object[]{serviceName});
        String result = CommandUtil.execCommand((String)format);
        return StrUtil.containsIgnoreCase((CharSequence)result, (CharSequence)"RUNNING");
    }

    @Override
    public String startService(String serviceName) {
        String format = StrUtil.format((CharSequence)"service {} start", (Object[])new Object[]{serviceName});
        return CommandUtil.execSystemCommand((String)format);
    }

    @Override
    public String stopService(String serviceName) {
        String format = StrUtil.format((CharSequence)"service {} stop", (Object[])new Object[]{serviceName});
        return CommandUtil.execSystemCommand((String)format);
    }
}

