/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common.commander.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.StrUtil;
import io.jpom.common.commander.AbstractProjectCommander;
import io.jpom.model.data.ProjectInfoModel;
import io.jpom.model.system.NetstatModel;
import io.jpom.util.CommandUtil;
import io.jpom.util.JvmUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LinuxProjectCommander
extends AbstractProjectCommander {
    @Override
    public String buildCommand(ProjectInfoModel projectInfoModel) {
        String path = ProjectInfoModel.getClassPathLib(projectInfoModel);
        if (StrUtil.isBlank((CharSequence)path)) {
            return null;
        }
        return String.format("nohup java %s %s %s  %s  %s >> %s 2>&1 &", projectInfoModel.getJvm(), JvmUtil.getJpomPidTag((String)projectInfoModel.getId(), (String)projectInfoModel.allLib()), path, projectInfoModel.getMainClass(), projectInfoModel.getArgs(), projectInfoModel.getAbsoluteLog());
    }

    @Override
    public String stop(ProjectInfoModel projectInfoModel) throws Exception {
        String result = super.stop(projectInfoModel);
        int pid = LinuxProjectCommander.parsePid(result);
        if (pid > 0) {
            String cmd = String.format("kill  %s", pid);
            CommandUtil.asyncExeLocalCommand((File)FileUtil.file((String)projectInfoModel.allLib()), (String)cmd);
            if (this.loopCheckRun(projectInfoModel.getId(), false)) {
                cmd = String.format("kill -9 %s", pid);
                CommandUtil.asyncExeLocalCommand((File)FileUtil.file((String)projectInfoModel.allLib()), (String)cmd);
            }
            String tag = projectInfoModel.getId();
            result = this.status(tag);
        }
        return result;
    }

    @Override
    public List<NetstatModel> listNetstat(int pId, boolean listening) {
        String cmd = listening ? "netstat -antup | grep " + pId + " |grep \"LISTEN\" | head -20" : "netstat -antup | grep " + pId + " |grep -v \"CLOSE_WAIT\" | head -20";
        String result = CommandUtil.execSystemCommand((String)cmd);
        List netList = StrSpliter.splitTrim((String)result, (String)"\n", (boolean)true);
        if (netList == null || netList.size() <= 0) {
            return null;
        }
        ArrayList<NetstatModel> array = new ArrayList<NetstatModel>();
        for (String str : netList) {
            List list = StrSpliter.splitTrim((String)str, (String)" ", (boolean)true);
            if (list.size() < 5) continue;
            NetstatModel netstatModel = new NetstatModel();
            netstatModel.setProtocol((String)list.get(0));
            netstatModel.setReceive((String)list.get(1));
            netstatModel.setSend((String)list.get(2));
            netstatModel.setLocal((String)list.get(3));
            netstatModel.setForeign((String)list.get(4));
            if ("tcp".equalsIgnoreCase(netstatModel.getProtocol())) {
                netstatModel.setStatus((String)list.get(5));
                netstatModel.setName((String)list.get(6));
            } else {
                netstatModel.setStatus("-");
                netstatModel.setName((String)list.get(5));
            }
            array.add(netstatModel);
        }
        return array;
    }
}

