/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common.commander;

import cn.hutool.http.HttpRequest;
import cn.hutool.system.SystemUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import io.jpom.common.commander.impl.LinuxTomcatCommander;
import io.jpom.common.commander.impl.WindowsTomcatCommander;
import io.jpom.model.data.TomcatInfoModel;
import io.jpom.system.JpomRuntimeException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTomcatCommander {
    private static AbstractTomcatCommander abstractTomcatCommander;

    public static AbstractTomcatCommander getInstance() {
        if (abstractTomcatCommander != null) {
            return abstractTomcatCommander;
        }
        if (SystemUtil.getOsInfo().isLinux()) {
            abstractTomcatCommander = new LinuxTomcatCommander();
        } else if (SystemUtil.getOsInfo().isWindows()) {
            abstractTomcatCommander = new WindowsTomcatCommander();
        } else if (SystemUtil.getOsInfo().isMac()) {
            abstractTomcatCommander = new LinuxTomcatCommander();
        } else {
            throw new JpomRuntimeException("\u4e0d\u652f\u6301\u7684\uff1a" + SystemUtil.getOsInfo().getName());
        }
        return abstractTomcatCommander;
    }

    public abstract String execCmd(TomcatInfoModel var1, String var2);

    protected String getStatus(TomcatInfoModel tomcatInfoModel, String cmd) {
        String strReturn = "start".equals(cmd) ? "stopped" : "started";
        int i = 0;
        while (i < 10) {
            boolean result = false;
            String url = String.format("http://127.0.0.1:%d/", tomcatInfoModel.getPort());
            HttpRequest httpRequest = new HttpRequest(url);
            httpRequest.setConnectionTimeout(3000);
            try {
                httpRequest.execute();
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
            if ("start".equals(cmd) && result) {
                strReturn = "started";
                break;
            }
            if ("stop".equals(cmd) && !result) {
                strReturn = "stopped";
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return strReturn;
    }

    protected void exec(String command, boolean close) {
        DefaultSystemLog.LOG().info(command);
        try {
            Process process = Runtime.getRuntime().exec(command);
            process.getInputStream().close();
            process.getErrorStream().close();
            process.getOutputStream().close();
            process.waitFor(5L, TimeUnit.SECONDS);
            if (close) {
                process.destroy();
            }
        }
        catch (IOException | InterruptedException e) {
            DefaultSystemLog.ERROR().error("tomcat\u6267\u884c\u540d\u79f0\u5931\u8d25", (Throwable)e);
        }
    }
}

