/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common.commander;

import cn.hutool.system.SystemUtil;
import com.alibaba.fastjson.JSONObject;
import io.jpom.common.commander.impl.LinuxSystemCommander;
import io.jpom.common.commander.impl.WindowsSystemCommander;
import io.jpom.model.system.ProcessModel;
import io.jpom.system.JpomRuntimeException;
import java.io.File;
import java.util.List;

public abstract class AbstractSystemCommander {
    private static AbstractSystemCommander abstractSystemCommander = null;

    public static AbstractSystemCommander getInstance() {
        if (abstractSystemCommander != null) {
            return abstractSystemCommander;
        }
        if (SystemUtil.getOsInfo().isLinux()) {
            abstractSystemCommander = new LinuxSystemCommander();
        } else if (SystemUtil.getOsInfo().isWindows()) {
            abstractSystemCommander = new WindowsSystemCommander();
        } else if (SystemUtil.getOsInfo().isMac()) {
            abstractSystemCommander = new LinuxSystemCommander();
        } else {
            throw new JpomRuntimeException("\u4e0d\u652f\u6301\u7684\uff1a" + SystemUtil.getOsInfo().getName());
        }
        return abstractSystemCommander;
    }

    public abstract JSONObject getAllMonitor();

    public abstract List<ProcessModel> getProcessList();

    public abstract ProcessModel getPidInfo(int var1);

    protected static String getHardDisk() {
        File[] files = File.listRoots();
        double totalSpace = 0.0;
        double useAbleSpace = 0.0;
        for (File file : files) {
            double total = file.getTotalSpace();
            totalSpace += total;
            useAbleSpace += total - (double)file.getUsableSpace();
        }
        return String.format("%.2f", useAbleSpace / totalSpace * 100.0);
    }

    public abstract boolean getServiceStatus(String var1);

    public abstract String startService(String var1);

    public abstract String stopService(String var1);
}

