/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common.commander;

import cn.hutool.cache.impl.LRUCache;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.format.DatePrinter;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.JarClassLoader;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.system.SystemUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.spring.SpringUtil;
import com.sun.tools.attach.VirtualMachine;
import io.jpom.common.commander.impl.LinuxProjectCommander;
import io.jpom.common.commander.impl.WindowsProjectCommander;
import io.jpom.model.RunMode;
import io.jpom.model.data.ProjectInfoModel;
import io.jpom.model.system.NetstatModel;
import io.jpom.service.manage.ProjectInfoService;
import io.jpom.system.JpomRuntimeException;
import io.jpom.util.CommandUtil;
import io.jpom.util.JvmUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class AbstractProjectCommander {
    public static final String RUNNING_TAG = "running";
    public static final String STOP_TAG = "stopped";
    private static AbstractProjectCommander abstractProjectCommander = null;
    public static final ConcurrentHashMap<Integer, String> PID_JPOM_NAME = new ConcurrentHashMap();
    public static final LRUCache<Integer, Integer> PID_PORT = new LRUCache(100, TimeUnit.MINUTES.toMillis(10L));

    public static AbstractProjectCommander getInstance() {
        if (abstractProjectCommander != null) {
            return abstractProjectCommander;
        }
        if (SystemUtil.getOsInfo().isLinux()) {
            abstractProjectCommander = new LinuxProjectCommander();
        } else if (SystemUtil.getOsInfo().isWindows()) {
            abstractProjectCommander = new WindowsProjectCommander();
        } else if (SystemUtil.getOsInfo().isMac()) {
            abstractProjectCommander = new LinuxProjectCommander();
        } else {
            throw new JpomRuntimeException("\u4e0d\u652f\u6301\u7684\uff1a" + SystemUtil.getOsInfo().getName());
        }
        return abstractProjectCommander;
    }

    public abstract String buildCommand(ProjectInfoModel var1);

    public String start(ProjectInfoModel projectInfoModel) throws Exception {
        String msg = this.checkStart(projectInfoModel);
        if (msg != null) {
            return msg;
        }
        String command = this.buildCommand(projectInfoModel);
        if (command == null) {
            throw new JpomRuntimeException("\u6ca1\u6709\u9700\u8981\u6267\u884c\u7684\u547d\u4ee4");
        }
        ThreadUtil.execute(() -> {
            try {
                CommandUtil.asyncExeLocalCommand((File)FileUtil.file((String)projectInfoModel.allLib()), (String)command);
            }
            catch (Exception e) {
                DefaultSystemLog.ERROR().error("\u6267\u884c\u547d\u4ee4\u5931\u8d25", (Throwable)e);
            }
        });
        this.loopCheckRun(projectInfoModel.getId(), true);
        return this.status(projectInfoModel.getId());
    }

    public abstract List<NetstatModel> listNetstat(int var1, boolean var2);

    public String stop(ProjectInfoModel projectInfoModel) throws Exception {
        String result;
        int pid;
        String tag = projectInfoModel.getId();
        String token = projectInfoModel.getToken();
        if (StrUtil.isNotEmpty((CharSequence)token)) {
            try {
                String body = HttpUtil.createGet((String)token).form("projectId", (Object)projectInfoModel.getId()).execute().body();
                DefaultSystemLog.LOG().info(projectInfoModel.getName() + ":" + body);
            }
            catch (Exception e) {
                DefaultSystemLog.ERROR().error("WebHooks \u8c03\u7528\u9519\u8bef", (Throwable)e);
                return "WebHooks error:" + e.getMessage();
            }
        }
        if ((pid = AbstractProjectCommander.parsePid(result = this.status(tag))) > 0) {
            PID_JPOM_NAME.remove(pid);
            PID_PORT.remove((Object)pid);
        }
        return result;
    }

    public String restart(ProjectInfoModel projectInfoModel) throws Exception {
        if (this.isRun(projectInfoModel.getId())) {
            this.stop(projectInfoModel);
        }
        return this.start(projectInfoModel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String checkStart(ProjectInfoModel projectInfoModel) throws Exception {
        int pid = this.getPid(projectInfoModel.getId());
        if (pid > 0) {
            return "\u5f53\u524d\u7a0b\u5e8f\u6b63\u5e38\u8fd0\u884c\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u542f\u52a8,PID:" + pid;
        }
        String lib = projectInfoModel.allLib();
        File fileLib = new File(lib);
        File[] files = fileLib.listFiles();
        if (files == null) return "\u6ca1\u6709jar\u5305,\u8bf7\u5148\u5230\u6587\u4ef6\u7ba1\u7406\u4e2d\u4e0a\u4f20\u7a0b\u5e8f\u7684jar";
        if (files.length <= 0) {
            return "\u6ca1\u6709jar\u5305,\u8bf7\u5148\u5230\u6587\u4ef6\u7ba1\u7406\u4e2d\u4e0a\u4f20\u7a0b\u5e8f\u7684jar";
        }
        if (projectInfoModel.getRunMode() == RunMode.ClassPath) {
            JarClassLoader jarClassLoader = JarClassLoader.load((File)fileLib);
            try {
                jarClassLoader.loadClass(projectInfoModel.getMainClass());
            }
            catch (ClassNotFoundException notFound) {
                return "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684MainClass:" + projectInfoModel.getMainClass();
            }
        }
        List<File> fileList = ProjectInfoModel.listJars(projectInfoModel);
        if (fileList == null) return "\u6ca1\u6709jar\u5305,\u8bf7\u5148\u5230\u6587\u4ef6\u7ba1\u7406\u4e2d\u4e0a\u4f20\u7a0b\u5e8f\u7684jar";
        if (fileList.size() <= 0) {
            return "\u6ca1\u6709jar\u5305,\u8bf7\u5148\u5230\u6587\u4ef6\u7ba1\u7406\u4e2d\u4e0a\u4f20\u7a0b\u5e8f\u7684jar";
        }
        File jarFile = fileList.get(0);
        try (JarFile jarFile1 = new JarFile(jarFile);){
            Manifest manifest = jarFile1.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String mainClass = attributes.getValue("Main-Class");
            if (mainClass == null) {
                String string = jarFile.getAbsolutePath() + "\u4e2d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684MainClass\u5c5e\u6027";
                return string;
            }
            JarClassLoader jarClassLoader = JarClassLoader.load((File)jarFile);
            try {
                jarClassLoader.loadClass(mainClass);
            }
            catch (ClassNotFoundException notFound) {
                String string = jarFile.getAbsolutePath() + "\u4e2d\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684MainClass:" + mainClass;
                if (jarFile1 == null) return string;
                if (var9_12 == null) {
                    jarFile1.close();
                    return string;
                }
                try {
                    jarFile1.close();
                    return string;
                }
                catch (Throwable throwable) {
                    var9_12.addSuppressed(throwable);
                    return string;
                }
            }
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u89e3\u6790jar", (Throwable)e);
            return jarFile.getAbsolutePath() + " \u89e3\u6790\u9519\u8bef:" + e.getMessage();
        }
        this.backLog(projectInfoModel);
        return null;
    }

    public String backLog(ProjectInfoModel projectInfoModel) {
        String r;
        if (StrUtil.isEmpty((CharSequence)projectInfoModel.getLog())) {
            return "ok";
        }
        File file = new File(projectInfoModel.getLog());
        if (!file.exists() || file.isDirectory()) {
            return "not exists";
        }
        if (file.length() <= 1000L) {
            return "ok";
        }
        File backPath = projectInfoModel.getLogBack();
        backPath = new File(backPath, DateTime.now().toString((DatePrinter)DatePattern.PURE_DATETIME_FORMAT) + ".log");
        FileUtil.copy((File)file, (File)backPath, (boolean)true);
        if (SystemUtil.getOsInfo().isLinux()) {
            CommandUtil.execCommand((String)("cp /dev/null " + projectInfoModel.getLog()));
        } else if (SystemUtil.getOsInfo().isWindows() && StrUtil.isEmpty((CharSequence)(r = CommandUtil.execSystemCommand((String)("echo  \"\" > " + file.getAbsolutePath()))))) {
            DefaultSystemLog.LOG().info(r);
        }
        return "ok";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String status(String tag) throws Exception {
        VirtualMachine virtualMachine = JvmUtil.getVirtualMachine((String)tag);
        if (virtualMachine == null) {
            return STOP_TAG;
        }
        try {
            String string = StrUtil.format((CharSequence)"{}:{}", (Object[])new Object[]{RUNNING_TAG, virtualMachine.id()});
            return string;
        }
        finally {
            virtualMachine.detach();
        }
    }

    public String getMainPort(int pid) {
        Integer cachePort = (Integer)PID_PORT.get((Object)pid);
        if (cachePort != null) {
            return cachePort.toString();
        }
        List<NetstatModel> list = this.listNetstat(pid, true);
        if (list == null) {
            return "-";
        }
        int port = Integer.MAX_VALUE;
        for (NetstatModel model : list) {
            int minPort;
            String local = model.getLocal();
            String portStr = this.getPortFormLocalIp(local);
            if (portStr == null || (minPort = Convert.toInt((Object)portStr, (Integer)Integer.MAX_VALUE).intValue()) >= port) continue;
            port = minPort;
        }
        if (port == Integer.MAX_VALUE) {
            return "-";
        }
        PID_PORT.put((Object)pid, (Object)port);
        return String.valueOf(port);
    }

    private String getPortFormLocalIp(String local) {
        if (StrUtil.isEmpty((CharSequence)local)) {
            return null;
        }
        List ipPort = StrSpliter.splitTrim((String)local, (String)":", (boolean)true);
        if (ipPort.isEmpty()) {
            return null;
        }
        if ("0.0.0.0".equals(ipPort.get(0)) || ipPort.size() == 1) {
            return (String)ipPort.get(ipPort.size() - 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJpomNameByPid(int pid) throws IOException {
        String name = PID_JPOM_NAME.get(pid);
        if (name != null) {
            return name;
        }
        ProjectInfoService projectInfoService = (ProjectInfoService)((Object)SpringUtil.getBean(ProjectInfoService.class));
        List projectInfoModels = projectInfoService.list();
        if (projectInfoModels == null || projectInfoModels.isEmpty()) {
            return "-";
        }
        VirtualMachine virtualMachine = JvmUtil.getVirtualMachine((int)pid);
        if (virtualMachine == null) {
            return "-";
        }
        try {
            for (ProjectInfoModel projectInfoModel : projectInfoModels) {
                if (!JvmUtil.checkVirtualMachineIsJpom((VirtualMachine)virtualMachine, (String)projectInfoModel.getId())) continue;
                name = projectInfoModel.getName();
                break;
            }
        }
        finally {
            virtualMachine.detach();
        }
        if (name != null) {
            PID_JPOM_NAME.put(pid, name);
            return name;
        }
        return "-";
    }

    public int getPid(String tag) throws Exception {
        String result = this.status(tag);
        return AbstractProjectCommander.parsePid(result);
    }

    protected static int parsePid(String result) {
        if (result.startsWith(RUNNING_TAG)) {
            return Convert.toInt((Object)result.split(":")[1]);
        }
        return 0;
    }

    public boolean isRun(String tag) throws Exception {
        String result = this.status(tag);
        return result.contains(RUNNING_TAG);
    }

    protected boolean loopCheckRun(String tag, boolean status) throws Exception {
        int count = 0;
        do {
            if (this.isRun(tag) == status) {
                return status;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (count++ < 20);
        return !status;
    }
}

