/*
 * Decompiled with CFR 0.152.
 */
package io.jpom.common;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.jiangzeyin.controller.base.AbstractController;
import io.jpom.common.BaseJpomController;
import io.jpom.model.data.ProjectInfoModel;
import io.jpom.service.manage.ProjectInfoService;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseAgentController
extends BaseJpomController {
    @Resource
    protected ProjectInfoService projectInfoService;

    protected String getUserName() {
        return BaseAgentController.getUserName(this.getRequest());
    }

    private static String getUserName(HttpServletRequest request) {
        String name = ServletUtil.getHeaderIgnoreCase((HttpServletRequest)request, (String)"Jpom-Server-UserName");
        name = CharsetUtil.convert((String)name, (Charset)CharsetUtil.CHARSET_ISO_8859_1, (Charset)CharsetUtil.CHARSET_UTF_8);
        name = StrUtil.emptyToDefault((CharSequence)name, (String)"-");
        return URLUtil.decode((String)name, (Charset)CharsetUtil.CHARSET_UTF_8);
    }

    public static String getNowUserName() {
        HttpServletRequest request = AbstractController.getRequestAttributes().getRequest();
        if (request == null) {
            return "-";
        }
        return BaseAgentController.getUserName(request);
    }

    protected ProjectInfoModel getProjectInfoModel() {
        ProjectInfoModel projectInfoModel = this.tryGetProjectInfoModel();
        Objects.requireNonNull(projectInfoModel, "\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25");
        return projectInfoModel;
    }

    protected ProjectInfoModel tryGetProjectInfoModel() {
        ProjectInfoModel projectInfoModel = null;
        String id = this.getParameter("id");
        if (StrUtil.isNotEmpty((CharSequence)id)) {
            projectInfoModel = (ProjectInfoModel)this.projectInfoService.getItem(id);
        }
        return projectInfoModel;
    }
}

