/*
 * Decompiled with CFR 0.152.
 */
package io.joj.fluence.util;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class SupplierFluence {
    private SupplierFluence() {
    }

    public static <T> Supplier<T> memoize(Supplier<T> supplier) {
        return new MemoizingSupplier<T>(supplier);
    }

    private static final class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        private static final long serialVersionUID = -7346764451425702926L;
        private final Supplier<T> delegate;
        private volatile transient T memoizedValue = null;

        public MemoizingSupplier(Supplier<T> supplier) {
            this.delegate = Objects.requireNonNull(supplier, "supplier cannot be null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            T value = this.memoizedValue;
            if (value == null) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    value = this.memoizedValue;
                    if (value == null) {
                        this.memoizedValue = value = Objects.requireNonNull(this.delegate.get(), "delegate supplier returned null value");
                    }
                }
            }
            return value;
        }

        public String toString() {
            String value = Optional.ofNullable(this.memoizedValue).orElse("no memoized value");
            return String.format("%s(%s, memoized=%s)", this.getClass().getSimpleName(), this.delegate, value);
        }
    }
}

