/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk.provider;

import com.itculate.sdk.ITculateApiException;
import com.itculate.sdk.provider.JsonElementPacker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.json.JSONObject;
import org.msgpack.MessagePack;
import org.msgpack.packer.BufferPacker;

public class Util {
    public static String compressForJson(JSONObject jsonObject) throws IOException {
        byte[] packed = Util.msgpack(jsonObject);
        byte[] compressed = Util.compress(packed);
        return Util.hexlify(compressed);
    }

    static byte[] compress(byte[] bytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(bytes);
        gzip.close();
        return out.toByteArray();
    }

    static String hexlify(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] msgpack(JSONObject json) throws IOException {
        try (BufferPacker bufferPacker = new MessagePack().createBufferPacker();){
            JsonElementPacker packer = new JsonElementPacker(bufferPacker);
            byte[] byArray = packer.pack(json);
            return byArray;
        }
    }

    static void checkResponse(CloseableHttpResponse response) throws ITculateApiException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 201) {
            String reasonPhrase = response.getStatusLine().getReasonPhrase();
            throw new ITculateApiException("Http Error " + statusCode + " " + reasonPhrase + " \r\n" + response.toString());
        }
    }
}

