/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk;

import com.itculate.sdk.Edge;
import com.itculate.sdk.Event;
import com.itculate.sdk.Sample;
import com.itculate.sdk.Vertex;
import com.itculate.sdk.types.DataType;
import com.itculate.sdk.types.NumberTypedValue;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class Payload {
    private TopologyPayload topologyPayload = new TopologyPayload();
    private EventsPayload eventsPayload = new EventsPayload();
    private TimeseriesPayload timeseriesPayload = new TimeseriesPayload();
    private DictionaryPayload dictionaryPayload = new DictionaryPayload();
    private String collectorId;

    public Payload(String collectorId) {
        this.collectorId = collectorId;
    }

    public String getCollectorId() {
        return this.collectorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JSONObject toJson() {
        TopologyPayload localTopologyPayload = this.topologyPayload;
        EventsPayload localEventsPayload = this.eventsPayload;
        TimeseriesPayload localTimeseriesPayload = this.timeseriesPayload;
        DictionaryPayload localDictionaryPayload = this.dictionaryPayload;
        Payload payload = this;
        synchronized (payload) {
            this.topologyPayload = new TopologyPayload();
            this.eventsPayload = new EventsPayload();
            this.timeseriesPayload = new TimeseriesPayload();
            this.dictionaryPayload = new DictionaryPayload();
        }
        JSONObject jsonObject = new JSONObject();
        localTopologyPayload.doFillJson(jsonObject);
        localEventsPayload.doFillJson(jsonObject, this.collectorId);
        localTimeseriesPayload.doFillJson(jsonObject);
        localDictionaryPayload.doFillJson(jsonObject);
        return jsonObject;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public void add(Vertex vertex) {
        this.topologyPayload.add(vertex);
        for (Map.Entry<String, NumberTypedValue> entry : vertex.getAttributeToTypedValue().entrySet()) {
            String attribute = entry.getKey();
            DataType dataType = entry.getValue().getDataType();
            String vertexKey = vertex.getDefaultKey();
            this.dictionaryPayload.add(vertexKey, DictionaryPayload.Type.VERTEX, attribute, dataType);
        }
    }

    public void add(Edge edge) {
        this.topologyPayload.add(edge);
    }

    public void add(Event event) {
        this.eventsPayload.add(event);
    }

    public void add(Sample sample) {
        this.timeseriesPayload.add(sample);
        this.dictionaryPayload.add(sample.getVertexKey(), DictionaryPayload.Type.TIMESERIES, sample.getCounter(), sample.getDataType());
    }

    private static class DictionaryPayload {
        private Map<String, Map<Type, Map<String, JSONObject>>> dictionary = new HashMap<String, Map<Type, Map<String, JSONObject>>>();
        private boolean changed = false;

        private DictionaryPayload() {
        }

        public boolean changed() {
            return this.changed;
        }

        private void doFillJson(JSONObject jsonToFill) {
            JSONObject jsonObject = new JSONObject();
            for (Map.Entry<String, Map<Type, Map<String, JSONObject>>> vertexKeyEntry : this.dictionary.entrySet()) {
                String vertexKey = vertexKeyEntry.getKey();
                JSONObject vertexKeyJosnObject = jsonObject.optJSONObject(vertexKey);
                if (vertexKeyJosnObject == null) {
                    vertexKeyJosnObject = new JSONObject();
                    jsonObject.put(vertexKey, (Object)vertexKeyJosnObject);
                }
                for (Map.Entry<Type, Map<String, JSONObject>> typeEntry : vertexKeyEntry.getValue().entrySet()) {
                    Type type = typeEntry.getKey();
                    JSONObject typeJsonObject = vertexKeyJosnObject.optJSONObject(type.getValue());
                    if (typeJsonObject == null) {
                        typeJsonObject = new JSONObject();
                        vertexKeyJosnObject.put(type.getValue(), (Object)typeJsonObject);
                    }
                    for (Map.Entry<String, JSONObject> attributeEntry : typeEntry.getValue().entrySet()) {
                        String attribute = attributeEntry.getKey();
                        JSONObject metaData = attributeEntry.getValue();
                        typeJsonObject.put(attribute, (Object)metaData);
                    }
                }
            }
            jsonToFill.put("dictionary", (Object)jsonObject);
        }

        public boolean add(String vertexKey, Type dictionaryType, String attribute, DataType dataType) {
            Map<String, JSONObject> dictionaryTypeJsonObject;
            Map<Type, Map<String, JSONObject>> vertexTypeJsonObject = this.dictionary.get(vertexKey);
            if (vertexTypeJsonObject == null) {
                vertexTypeJsonObject = new HashMap<Type, Map<String, JSONObject>>();
                this.dictionary.put(vertexKey, vertexTypeJsonObject);
            }
            if ((dictionaryTypeJsonObject = vertexTypeJsonObject.get((Object)dictionaryType)) == null) {
                dictionaryTypeJsonObject = new HashMap<String, JSONObject>();
                vertexTypeJsonObject.put(dictionaryType, dictionaryTypeJsonObject);
            }
            JSONObject currentMetaData = dataType.toJson();
            JSONObject dictionaryMetaData = dictionaryTypeJsonObject.get(attribute);
            if (dictionaryMetaData == null) {
                dictionaryTypeJsonObject.put(attribute, currentMetaData);
                this.changed = true;
                return true;
            }
            if (!this.compareJson(dictionaryMetaData, currentMetaData)) {
                dictionaryTypeJsonObject.put(attribute, currentMetaData);
                this.changed = true;
                return true;
            }
            return false;
        }

        private boolean compareJson(JSONObject json1, JSONObject json2) {
            if (json1 == null && json2 == null) {
                return true;
            }
            if (json1 == null || json2 == null) {
                return false;
            }
            if (json1.length() != json2.length()) {
                return false;
            }
            Set<String> json1keySet = this.dictionary.keySet();
            for (String json1key : json1keySet) {
                Object value1 = json1.opt(json1key);
                Object value2 = json2.opt(json1key);
                if (value1 == null && value2 == null) continue;
                if (value1 == null || value2 == null) {
                    return false;
                }
                if (!value1.getClass().equals(value2.getClass())) {
                    return false;
                }
                if (!(value1 instanceof JSONObject ? !this.compareJson((JSONObject)value1, (JSONObject)value2) : (value1 instanceof JSONArray ? !this.compareJson((JSONArray)value1, (JSONArray)value2) : !this.compareJson(value1, value2)))) continue;
                return false;
            }
            return true;
        }

        private boolean compareJson(JSONArray json1, JSONArray json2) {
            if (json1 == null && json2 == null) {
                return true;
            }
            if (json1 == null || json2 == null) {
                return false;
            }
            if (json1.length() != json2.length()) {
                return false;
            }
            for (int i = 0; i < json1.length(); ++i) {
                Object value1 = json1.opt(i);
                Object value2 = json2.opt(i);
                if (value1 == null || value2 == null) {
                    return false;
                }
                if (!value1.getClass().equals(value2.getClass())) {
                    return false;
                }
                if (!(value1 instanceof JSONObject ? !this.compareJson((JSONObject)value1, (JSONObject)value2) : (value1 instanceof JSONArray ? !this.compareJson((JSONArray)value1, (JSONArray)value2) : !this.compareJson(value1, value2)))) continue;
                return false;
            }
            return true;
        }

        private boolean compareJson(Object value1, Object value2) {
            if (value1 == null && value2 == null) {
                return true;
            }
            if (value1 == null || value2 == null) {
                return false;
            }
            return value1.equals(value2);
        }

        public static enum Type {
            VERTEX("vertex"),
            TIMESERIES("timeseries");

            String value;

            private Type(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }
        }
    }

    private static class TimeseriesPayload {
        private List<Sample> samples = new LinkedList<Sample>();

        private TimeseriesPayload() {
        }

        private void doFillJson(JSONObject jsonToFill) {
            JSONObject jsonObject = new JSONObject();
            for (Sample sample : this.samples) {
                JSONArray values;
                String vertexKey = sample.getVertexKey();
                String counter = sample.getCounter();
                Number value = sample.getValue();
                double timestamp = sample.getTimestamp() / 1000L;
                JSONObject counterValues = jsonObject.optJSONObject(vertexKey);
                if (counterValues == null) {
                    counterValues = new JSONObject();
                    jsonObject.put(vertexKey, (Object)counterValues);
                }
                if ((values = counterValues.optJSONArray(counter)) == null) {
                    values = new JSONArray();
                }
                counterValues.put(counter, (Object)values);
                JSONArray timestampValueTuple = new JSONArray();
                timestampValueTuple.put(timestamp);
                timestampValueTuple.put((Object)value);
                values.put((Object)timestampValueTuple);
            }
            jsonToFill.put("samples", (Object)jsonObject);
        }

        public void add(Sample sample) {
            this.samples.add(sample);
        }
    }

    private static class TopologyPayload {
        private List<Vertex> vertices = new LinkedList<Vertex>();
        private List<Edge> edges = new LinkedList<Edge>();

        private TopologyPayload() {
        }

        private JSONObject doFillJson(JSONObject jsonToFill) {
            JSONArray verticesJsonArray = new JSONArray();
            for (Vertex vertex : this.vertices) {
                verticesJsonArray.put((Object)vertex.toJson());
            }
            JSONArray edgesJsonArray = new JSONArray();
            for (Edge edge : this.edges) {
                edgesJsonArray.put((Object)edge.toJson());
            }
            jsonToFill.put("vertices", (Object)verticesJsonArray);
            jsonToFill.put("edges", (Object)edgesJsonArray);
            return jsonToFill;
        }

        public void add(Vertex vertex) {
            this.vertices.add(vertex);
        }

        public void add(Edge edge) {
            this.edges.add(edge);
        }
    }

    private static class EventsPayload {
        private List<Event> events = new LinkedList<Event>();

        private EventsPayload() {
        }

        private JSONObject doFillJson(JSONObject jsonToFill, String collectorId) {
            JSONArray eventsJsonArray = new JSONArray();
            for (Event event : this.events) {
                eventsJsonArray.put((Object)event.toJson(collectorId));
            }
            jsonToFill.put("events", (Object)eventsJsonArray);
            return jsonToFill;
        }

        public void add(Event event) {
            this.events.add(event);
        }
    }
}

