/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk;

import com.itculate.sdk.Edge;
import com.itculate.sdk.Event;
import com.itculate.sdk.ITculateApiException;
import com.itculate.sdk.Payload;
import com.itculate.sdk.Sample;
import com.itculate.sdk.Vertex;
import com.itculate.sdk.provider.AgentProvider;
import com.itculate.sdk.provider.Provider;
import com.itculate.sdk.provider.SynchronousApiProvider;
import java.util.HashMap;
import java.util.Map;

public class ITculateSDK {
    private static String _DEFAULT_COLLECTOR_ID = "sdk";
    private Provider provider;
    private Map<String, Payload> collectorIdToPayloads = new HashMap<String, Payload>();

    private ITculateSDK(Provider provider) {
        this.provider = provider;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void addVertex(String collectorId, Vertex vertex) throws ITculateApiException {
        this.getPayload(collectorId).add(vertex);
    }

    public void addEdge(String collectorId, Edge edge) {
        this.getPayload(collectorId).add(edge);
    }

    public void addEvent(String collectorId, Event event) {
        this.getPayload(collectorId).add(event);
    }

    public void addSample(Sample sample) {
        this.getPayload(_DEFAULT_COLLECTOR_ID).add(sample);
    }

    public void flushAll() throws ITculateApiException {
        for (Payload payload : this.collectorIdToPayloads.values()) {
            this.provider.flush(payload.getCollectorId(), payload.toJson());
        }
    }

    private Payload getPayload(String collectorId) {
        Payload payload = this.collectorIdToPayloads.get(collectorId);
        if (payload == null) {
            payload = new Payload(collectorId);
        }
        this.collectorIdToPayloads.put(collectorId, payload);
        return payload;
    }

    public static class Builder {
        private String serverUrl = null;
        private boolean agent = true;
        private String apiKey;
        private String apiSecret;
        private Provider provider;

        public Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder agent(boolean agent) {
            this.agent = agent;
            return this;
        }

        public Builder provider(Provider provider) {
            this.provider = provider;
            this.agent = false;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return this;
        }

        public ITculateSDK build() {
            if (this.provider != null) {
                if (this.agent) {
                    throw new IllegalStateException("When use provider, agent cannot be set");
                }
                if (this.serverUrl != null) {
                    throw new IllegalStateException("When use provider, serverUrl cannot be set");
                }
                if (this.apiKey != null || this.apiSecret != null) {
                    throw new IllegalStateException("When use provider, apiKey and apiSecret cannot be set");
                }
            } else {
                this.provider = this.agent ? new AgentProvider(this.serverUrl) : new SynchronousApiProvider(this.serverUrl, this.apiKey, this.apiSecret);
            }
            return new ITculateSDK(this.provider);
        }
    }
}

