# Java SDK #

Java client SDK providing convenient wrapper for the ITculate upload REST API to upload graph, time-series and dictionary data to the ITculate engine.


# REST API #

The SDK is using the ITculate REST API to upload data. This API can be used directly, given an API key for the 'upload' role.

### Endpoint ###
POST https://api.itculate.io/api/v1/upload

    Content-Type: application/json
    Accept: application/json
    Authorization: Basic <<< ENCODED KEYS >>>

Simple authentication with api key pair for the '**upload**' role. This is the same user (and role) used to upload data with the ITculate collector module. An API key can be retrieved from the web UI.

### Collector ID ###

* Format: a-z, A-Z, 0-9 or '_' only
* Unique (within the tenant)

Represents the 'reporter' of the topology and is used by the ITculate engine to detect changes between subsequents reports made by the same collector.

After the first report, the collector status can be viewed using the https://api.itculate.io/api/v1/collectors/ endpoint.

Removing a collector (and deleting everything it reported) can be done via a DELETE http call to https://api.itculate.io/api/v1/collectors/your_collector_id endpoint.

### Collector Version ###

Any string representing the version of the code that collected the data. This information can be tracked in the collectors view (or https://api.itculate.io/api/v1/collectors/).

### Host ###

A string representing the machine that hosts the collector. This information can be tracked in the collectors view (or https://api.itculate.io/api/v1/collectors/).

### Vertices ###

Each vertex document describes a single vertex in the graph.
A vertex is a document that contain any data, and has a few mandatory attributes.

##### Keys ("_keys") #####
A vertex can have more than one key. Keys are provided with names (mostly used for reference) and need to be globally unique.
These keys are used by the ITculate engine to identify existing vertices, as well as connecting between edges to form graphs.

##### Type ("_type") #####
Vertex type is a string that categorizes the vertex and allows visual grouping. Each vertex type will be assigned a unique color (or icon) to represent it visually on the graph.

##### Name ("_name") #####
A human readable display name for the vertex.

##### Custom attributes #####
Since a vertex is a document, it can hold any number of additional custom attributes (their name should NOT start with "_"). These attributes can be used to add information about the vertex, contact information, URLs to documentation, etc...


### Edges ###
Edges represent connections between vertices in the graph. Each edge identified the 'source' and 'target' vertices it connects and is associated with a type.

A graph that traverses a specific edge type is called a 'Topology'. Topologies are used to represent different layers and perspectives of the architecture and infrastructure.

##### Edge Type ("_type") #####
The edge type.

* Edge type should NOT start with "_".
* There is no limit for the number of edge types.
* There is no limit to the number of edges (of different types) that can connect two vertices.

##### Source ("_source_keys") and Target ("_target_keys") keys #####
Identify the source / target vertex the edge connects.

* Can be a subset of the vertex keys (at least one needs to match)
* An edge will be created only if BOTH source AND target keys are resolved to existing vertices in the DB

### JSON example ###

    {
        "collector_id": "unique_collector_id",
        "collector_version": "0.1.1",
        "host": "1.1.1.1",
        "vertices": [
            {
                "_type": "MyVertexType",
                "_name": "The vertex display name",
                "_keys": {
                    "any_key_name1": "globally_unique_key_value1",
                    "any_key_name2": "globally_unique_key_value2",
                    ...
                },
                "custom_attribute1": "Anything",
                ...
            },
            ...
        ],
        "edges": [
            {
                "_type": "my_edge_type",
                "_source_keys": {
                    # One of more of a vertex keys
                    "any_key_name1": "globally_unique_key_value1",
                },
                "_target_keys": {
                    # One or more of a vertex keys
                    "any_key_name2": "globally_unique_key_value2",
                }
            },
            ...
        ],
    }

### Who do I talk to? ###

* email to opensource@itculate.io