/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk.provider;

import com.itculate.sdk.ITculateApiException;
import com.itculate.sdk.provider.Provider;
import com.itculate.sdk.provider.Util;
import java.net.InetAddress;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.json.JSONObject;

public class AgentProvider
implements Provider {
    private static String DEFAULT_AGENT_REST_URL = "http://localhost:8000";
    private String serverUrl = null;

    public AgentProvider(String serverUrl) {
        if (serverUrl == null) {
            serverUrl = DEFAULT_AGENT_REST_URL;
        }
        this.serverUrl = serverUrl;
    }

    @Override
    public void flush(String collectorId, JSONObject jsonObject) throws ITculateApiException {
        if (this.serverUrl == null) {
            throw new IllegalStateException("serverUrl can not be null");
        }
        if (jsonObject == null) {
            throw new IllegalStateException("jsonObject must not be null");
        }
        if (collectorId == null) {
            throw new IllegalStateException("collectorId must not be null");
        }
        URI uri = URI.create(this.serverUrl);
        String host = uri.getHost();
        int port = uri.getPort();
        String scheme = uri.getScheme();
        HttpHost targetHost = new HttpHost(host, port, scheme);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setAuthCache((AuthCache)authCache);
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("default").build();
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(globalConfig).build();
        try {
            jsonObject.put("host", (Object)InetAddress.getLocalHost().getHostAddress());
            jsonObject.put("collector_id", (Object)collectorId);
            jsonObject.put("collector_version", (Object)"0.1.1");
            HttpPost httpPost = new HttpPost("/api/v1/upload");
            StringEntity entity = new StringEntity(jsonObject.toString());
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = httpclient.execute(targetHost, (HttpRequest)httpPost, (HttpContext)context);
            Util.checkResponse(response);
        }
        catch (Exception e) {
            throw new ITculateApiException("Failed to flush collectorId " + collectorId, e);
        }
    }
}

