/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk.types;

import com.itculate.sdk.types.Base;
import com.itculate.sdk.types.DataType;
import com.itculate.sdk.types.LatencyDataType;
import com.itculate.sdk.types.NumberTypedValue;
import com.itculate.sdk.types.Unit;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class DataTypeWithUnit
extends DataType {
    private Unit unit;
    private Base base;
    private static DataTypeWithUnit default_type;

    DataTypeWithUnit(Builder builder) {
        super(builder);
        this.unit = builder.unit;
        this.base = builder.base;
    }

    public static NumberTypedValue value(Number value) {
        if (default_type == null) {
            default_type = LatencyDataType.builder().build();
        }
        return new NumberTypedValue(default_type, value);
    }

    public NumberTypedValue getTypedValue(Number value) {
        return new NumberTypedValue(this, value);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = super.toJson();
        jsonObject.put("getTypedValue", (Object)this.unit.getValue());
        jsonObject.put("getTypedValue", this.base.getValue());
        JSONArray units = new JSONArray();
        units.put((Object)this.unit.getValue());
        JSONArray bases = new JSONArray();
        bases.put(this.base.getValue());
        jsonObject.put("units", (Object)units);
        jsonObject.put("bases", (Object)bases);
        return jsonObject;
    }

    static abstract class Builder<T extends DataTypeWithUnit>
    extends DataType.Builder<T> {
        Unit unit;
        Base base;

        public Builder<T> unit(Unit unit) {
            this.unit = unit;
            return this;
        }

        public Builder<T> base(Base base) {
            this.base = base;
            return this;
        }

        @Override
        public abstract T build();
    }
}

