/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk.provider;

import com.itculate.sdk.ITculateApiException;
import com.itculate.sdk.provider.Provider;
import com.itculate.sdk.provider.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Paths;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.json.JSONObject;

public class SynchronousApiProvider
implements Provider {
    private String apiKey = null;
    private String apiSecret = null;
    private String serverUrl = null;
    private String apiEndPoint = null;
    protected String credentialsRole = "upload";

    public SynchronousApiProvider(String serverUrl, String apiKey, String apiSecret) {
        if (serverUrl == null) {
            serverUrl = "https://api.itculate.io";
        }
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.serverUrl = serverUrl;
        this.apiEndPoint = "/api/v1/upload";
        if (this.apiKey == null && this.apiSecret == null) {
            this.loadCredentialsFromFile();
        }
    }

    private void loadCredentialsFromFile() {
        String path = Paths.get(System.getProperty("user.home"), ".itculate", "credentials").toString();
        String role = "[" + this.credentialsRole + "]";
        try {
            if (new File(path).exists()) {
                String input;
                BufferedReader fr = new BufferedReader(new FileReader(path));
                boolean roleFound = false;
                while ((input = fr.readLine()) != null) {
                    if (input.isEmpty()) continue;
                    if (input.equals(role)) {
                        roleFound = true;
                        continue;
                    }
                    if (roleFound) {
                        if (input.startsWith("api_key=")) {
                            this.apiKey = input.substring(8);
                        } else if (input.startsWith("api_secret=")) {
                            this.apiSecret = input.substring(11);
                        }
                    }
                    if (this.apiKey == null || this.apiSecret == null) continue;
                }
                fr.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load credentials [" + this.credentialsRole + "] from " + path);
        }
        if (this.apiKey == null || this.apiSecret == null) {
            throw new IllegalStateException("Failed to load credentials [" + this.credentialsRole + "] from " + path);
        }
    }

    @Override
    public void flush(String collectorId, JSONObject jsonObject) throws ITculateApiException {
        if (this.serverUrl == null || this.apiKey == null || this.apiSecret == null) {
            throw new IllegalStateException("serverUrl, apiKey and apiSecret cannot be null");
        }
        if (jsonObject == null) {
            throw new IllegalStateException("jsonObject must not be null");
        }
        if (collectorId == null) {
            throw new IllegalStateException("collectorId must not be null");
        }
        try {
            JSONObject jsonEntity = new JSONObject();
            jsonEntity.put("compressed_payload", (Object)Util.compressForJson(jsonObject));
            jsonEntity.put("collector_id", (Object)collectorId);
            jsonEntity.put("collector_version", (Object)"0.1.1");
            jsonEntity.put("host", (Object)InetAddress.getLocalHost().getHostAddress());
            String payload = jsonEntity.toString();
            URI uri = URI.create(this.serverUrl);
            this.doPost(uri, payload);
        }
        catch (Exception e) {
            throw new ITculateApiException("Failed to flush payload collectorId " + collectorId, e);
        }
    }

    protected void doPost(URI apiServerUri, String payload) throws Exception {
        String host = apiServerUri.getHost();
        int port = apiServerUri.getPort();
        String scheme = apiServerUri.getScheme();
        HttpHost targetHost = new HttpHost(host, port, scheme);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.apiKey, this.apiSecret);
        AuthScope authScope = AuthScope.ANY;
        credsProvider.setCredentials(authScope, (Credentials)credentials);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        context.setAuthCache((AuthCache)authCache);
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("default").build();
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(globalConfig).build();
        StringEntity entity = new StringEntity(payload);
        entity.setContentType("application/json");
        HttpPost httpPost = new HttpPost(this.apiEndPoint);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = httpclient.execute(targetHost, (HttpRequest)httpPost, (HttpContext)context);
        Util.checkResponse(response);
    }
}

