/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk.provider;

import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.msgpack.packer.BufferPacker;

class JsonElementPacker {
    private BufferPacker packer;

    JsonElementPacker(BufferPacker packer) {
        this.packer = packer;
    }

    byte[] pack(JSONObject jsonObject) throws IOException {
        this.doPack(jsonObject);
        return this.packer.toByteArray();
    }

    private void doPack(JSONObject jsonObject) throws IOException {
        this.packer.writeMapBegin(jsonObject.length());
        for (Object key : jsonObject.keySet()) {
            this.packer.write(key);
            Object value = jsonObject.get((String)key);
            if (value instanceof JSONObject) {
                this.doPack((JSONObject)value);
                continue;
            }
            if (value instanceof JSONArray) {
                this.doPack((JSONArray)value);
                continue;
            }
            this.doPack(value);
        }
        this.packer.writeMapEnd();
    }

    private void doPack(JSONArray jsonArray) throws IOException {
        this.packer.writeArrayBegin(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            Object value = jsonArray.get(i);
            if (value instanceof JSONObject) {
                this.doPack((JSONObject)value);
                continue;
            }
            if (value instanceof JSONArray) {
                this.doPack((JSONArray)value);
                continue;
            }
            this.doPack(value);
        }
        this.packer.writeArrayEnd();
    }

    private void doPack(Object value) throws IOException {
        this.packer.write(value);
    }
}

