/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk;

import com.itculate.sdk.Vertex;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class Edge {
    private Map<String, String> source;
    private Map<String, String> target;
    private String type;

    private Edge(Builder builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.type = builder.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("_type", (Object)this.type);
        JSONObject sourceKeysJsonObject = new JSONObject();
        for (Map.Entry<String, String> next : this.source.entrySet()) {
            sourceKeysJsonObject.put(next.getKey(), (Object)next.getValue());
        }
        JSONObject targetKeysJsonObject = new JSONObject();
        for (Map.Entry<String, String> next : this.target.entrySet()) {
            targetKeysJsonObject.put(next.getKey(), (Object)next.getValue());
        }
        jsonObject.put("_source_keys", (Object)sourceKeysJsonObject);
        jsonObject.put("_target_keys", (Object)targetKeysJsonObject);
        return jsonObject;
    }

    public static class Builder {
        private Map<String, String> source;
        private Map<String, String> target;
        private String type;

        public Builder source(Map<String, String> source) {
            this.source = source;
            return this;
        }

        public Builder source(String sourceKey) {
            this.source = new HashMap<String, String>();
            this.source.put("pk", sourceKey);
            return this;
        }

        public Builder source(Vertex vertex) {
            this.source = vertex.getKeys();
            return this;
        }

        public Builder target(Map<String, String> keys) {
            this.target = keys;
            return this;
        }

        public Builder target(String targetKey) {
            this.target = new HashMap<String, String>();
            this.target.put("pk", targetKey);
            return this;
        }

        public Builder target(Vertex vertex) {
            this.target = vertex.getKeys();
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Edge build() {
            if (this.type == null || this.source == null || this.target == null) {
                throw new IllegalStateException("getTypedValue, source and target must be provided");
            }
            if (this.source.isEmpty()) {
                throw new IllegalStateException("source keys cannot be empty");
            }
            if (this.target.isEmpty()) {
                throw new IllegalStateException("target keys cannot be empty");
            }
            return new Edge(this);
        }
    }
}

