/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk.provider;

import com.itculate.sdk.ITculateApiException;
import com.itculate.sdk.provider.Provider;
import com.itculate.sdk.provider.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.json.JSONObject;

public class SynchronousApiProvider
implements Provider {
    private String apiKey = null;
    private String apiSecret = null;
    private String serverUrl = null;
    private String apiEndPoint = null;

    public SynchronousApiProvider(String serverUrl, String apiKey, String apiSecret) {
        if (serverUrl == null) {
            serverUrl = "https://api.itculate.io";
        }
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.serverUrl = serverUrl;
        this.apiEndPoint = "/api/v1/upload";
        if (this.apiKey == null && this.apiSecret == null) {
            this.loadCredentialsFromFile();
        }
    }

    private void loadCredentialsFromFile() {
        Properties props = new Properties();
        String path = Paths.get(System.getProperty("user.home"), ".itculate", "credentials").toString();
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalStateException("Failed api key, file " + path + " doesn't exist");
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            props.load(input);
            this.apiKey = props.getProperty("api_key");
            if (this.apiKey == null) {
                throw new IllegalStateException("Failed to find api_key in " + path);
            }
            this.apiSecret = props.getProperty("api_secret");
            if (this.apiSecret == null) {
                throw new IllegalStateException("Failed to find api_secret in " + path);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load api_key and api_secret from " + path);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public int flush(String collectorId, JSONObject jsonObject) throws ITculateApiException {
        if (this.serverUrl == null || this.apiKey == null || this.apiSecret == null) {
            throw new IllegalStateException("serverUrl, apiKey and apiSecret cannot be null");
        }
        if (jsonObject == null) {
            throw new IllegalStateException("jsonObject must not be null");
        }
        if (collectorId == null) {
            throw new IllegalStateException("collectorId must not be null");
        }
        try {
            JSONObject jsonEntity = new JSONObject();
            jsonEntity.put("compressed_payload", (Object)Util.compressForJson(jsonObject));
            jsonEntity.put("collector_id", (Object)collectorId);
            jsonEntity.put("collector_version", (Object)"0.1.1");
            jsonEntity.put("host", (Object)InetAddress.getLocalHost().getHostAddress());
            String payload = jsonEntity.toString();
            URI uri = URI.create(this.serverUrl);
            return this.doPost(uri, payload);
        }
        catch (IOException e) {
            throw new ITculateApiException("Failed to flush payload collectorId " + collectorId, e);
        }
    }

    protected int doPost(URI apiServerUri, String payload) throws IOException {
        String host = apiServerUri.getHost();
        int port = apiServerUri.getPort();
        String scheme = apiServerUri.getScheme();
        HttpHost targetHost = new HttpHost(host, port, scheme);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.apiKey, this.apiSecret);
        AuthScope authScope = AuthScope.ANY;
        credsProvider.setCredentials(authScope, (Credentials)credentials);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        context.setAuthCache((AuthCache)authCache);
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("default").build();
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(globalConfig).build();
        StringEntity entity = new StringEntity(payload);
        entity.setContentType("application/json");
        HttpPost httpPost = new HttpPost(this.apiEndPoint);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = httpclient.execute(targetHost, (HttpRequest)httpPost, (HttpContext)context);
        return response.getStatusLine().getStatusCode();
    }
}

