/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk.payloads;

import com.itculate.sdk.Edge;
import com.itculate.sdk.Vertex;
import com.itculate.sdk.payloads.Payload;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class TopologyPayload
extends Payload {
    private List<Vertex> vertices = new LinkedList<Vertex>();
    private List<Edge> edges = new LinkedList<Edge>();

    public TopologyPayload(String collectorId) {
        super(collectorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JSONObject toJson(boolean reset) {
        List<Edge> localEdges;
        List<Vertex> localVertices;
        TopologyPayload topologyPayload = this;
        synchronized (topologyPayload) {
            localVertices = this.vertices;
            localEdges = this.edges;
            if (reset) {
                this.vertices = new LinkedList<Vertex>();
                this.edges = new LinkedList<Edge>();
            }
        }
        JSONObject jsonObject = new JSONObject();
        return this.doFillJson(localVertices, localEdges, jsonObject);
    }

    private JSONObject doFillJson(List<Vertex> localVertices, List<Edge> localEdges, JSONObject jsonToFill) {
        JSONArray verticesJsonArray = new JSONArray();
        for (Vertex vertex : localVertices) {
            verticesJsonArray.put((Object)vertex.toJson());
        }
        JSONArray edgesJsonArray = new JSONArray();
        for (Edge edge : localEdges) {
            edgesJsonArray.put((Object)edge.toJson());
        }
        jsonToFill.put("vertices", (Object)verticesJsonArray);
        jsonToFill.put("edges", (Object)edgesJsonArray);
        return jsonToFill;
    }

    public void add(Vertex vertex) {
        this.vertices.add(vertex);
    }

    public void add(Edge edge) {
        this.edges.add(edge);
    }
}

