/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk.payloads;

import com.itculate.sdk.Sample;
import com.itculate.sdk.payloads.Payload;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class TimeseriesPayload
extends Payload {
    private List<Sample> samples = new LinkedList<Sample>();

    public TimeseriesPayload(String collectorId) {
        super(collectorId);
    }

    @Override
    public boolean changed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JSONObject toJson(boolean reset) {
        List<Sample> localSamples;
        TimeseriesPayload timeseriesPayload = this;
        synchronized (timeseriesPayload) {
            localSamples = this.samples;
            if (reset) {
                this.samples = new LinkedList<Sample>();
            }
        }
        JSONObject jsonObject = new JSONObject();
        this.doFillJson(localSamples, jsonObject);
        return jsonObject;
    }

    private void doFillJson(List<Sample> localSamples, JSONObject jsonToFill) {
        JSONObject jsonObject = new JSONObject();
        for (Sample sample : localSamples) {
            JSONArray values;
            String vertexKey = sample.getVertexKey();
            String counter = sample.getCounter();
            Number value = sample.getValue();
            double timestamp = sample.getTimestamp() / 1000L;
            JSONObject counterValues = jsonObject.optJSONObject(vertexKey);
            if (counterValues == null) {
                counterValues = new JSONObject();
                jsonObject.put(vertexKey, (Object)counterValues);
            }
            if ((values = counterValues.optJSONArray(counter)) == null) {
                values = new JSONArray();
            }
            counterValues.put(counter, (Object)values);
            JSONArray timestampValueTuple = new JSONArray();
            timestampValueTuple.put(timestamp);
            timestampValueTuple.put((Object)value);
            values.put((Object)timestampValueTuple);
        }
        jsonToFill.put("samples", (Object)jsonObject);
    }

    public void add(Sample sample) {
        this.samples.add(sample);
    }
}

