/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk.payloads;

import com.itculate.sdk.payloads.Payload;
import com.itculate.sdk.types.DataType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class DictionaryPayload
extends Payload {
    private Map<String, Map<Type, Map<String, JSONObject>>> dictionary = new HashMap<String, Map<Type, Map<String, JSONObject>>>();
    private boolean changed = false;

    public DictionaryPayload(String collectorId) {
        super(collectorId);
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JSONObject toJson(boolean reset) {
        Map<String, Map<Type, Map<String, JSONObject>>> localDictionary;
        DictionaryPayload dictionaryPayload = this;
        synchronized (dictionaryPayload) {
            localDictionary = this.dictionary;
            if (reset) {
                this.dictionary = new HashMap<String, Map<Type, Map<String, JSONObject>>>();
                this.changed = false;
            }
        }
        JSONObject jsonObject = new JSONObject();
        this.doFillJson(localDictionary, jsonObject);
        return jsonObject;
    }

    private void doFillJson(Map<String, Map<Type, Map<String, JSONObject>>> localDictionary, JSONObject jsonToFill) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Map<Type, Map<String, JSONObject>>> vertexKeydEntry : localDictionary.entrySet()) {
            String vertexKey = vertexKeydEntry.getKey();
            JSONObject vertexKeyJosnObject = jsonObject.optJSONObject(vertexKey);
            if (vertexKeyJosnObject == null) {
                vertexKeyJosnObject = new JSONObject();
                jsonObject.put(vertexKey, (Object)vertexKeyJosnObject);
            }
            for (Map.Entry<Type, Map<String, JSONObject>> typeEntry : vertexKeydEntry.getValue().entrySet()) {
                Type type = typeEntry.getKey();
                JSONObject typeJsonObject = vertexKeyJosnObject.optJSONObject(type.getValue());
                if (typeJsonObject == null) {
                    typeJsonObject = new JSONObject();
                    vertexKeyJosnObject.put(type.getValue(), (Object)typeJsonObject);
                }
                for (Map.Entry<String, JSONObject> attributeEntry : typeEntry.getValue().entrySet()) {
                    String attribute = attributeEntry.getKey();
                    JSONObject metaData = attributeEntry.getValue();
                    typeJsonObject.put(attribute, (Object)metaData);
                }
            }
        }
        jsonToFill.put("dictionary", (Object)jsonObject);
    }

    public boolean add(String vertexKey, Type dictionaryType, String attribute, DataType dataType) {
        Map<String, JSONObject> dictionaryTypeJsonObject;
        Map<Type, Map<String, JSONObject>> vertexTypeJsonObject = this.dictionary.get(vertexKey);
        if (vertexTypeJsonObject == null) {
            vertexTypeJsonObject = new HashMap<Type, Map<String, JSONObject>>();
            this.dictionary.put(vertexKey, vertexTypeJsonObject);
        }
        if ((dictionaryTypeJsonObject = vertexTypeJsonObject.get((Object)dictionaryType)) == null) {
            dictionaryTypeJsonObject = new HashMap<String, JSONObject>();
            vertexTypeJsonObject.put(dictionaryType, dictionaryTypeJsonObject);
        }
        JSONObject currentMetaData = dataType.toJson();
        JSONObject dictionaryMetaData = dictionaryTypeJsonObject.get(attribute);
        if (dictionaryMetaData == null) {
            dictionaryTypeJsonObject.put(attribute, currentMetaData);
            this.changed = true;
            return true;
        }
        if (!this.compareJson(dictionaryMetaData, currentMetaData)) {
            dictionaryTypeJsonObject.put(attribute, currentMetaData);
            this.changed = true;
            return true;
        }
        return false;
    }

    private boolean compareJson(JSONObject json1, JSONObject json2) {
        if (json1 == null && json2 == null) {
            return true;
        }
        if (json1 == null || json2 == null) {
            return false;
        }
        if (json1.length() != json2.length()) {
            return false;
        }
        Set<String> json1keySet = this.dictionary.keySet();
        for (String json1key : json1keySet) {
            Object value1 = json1.opt(json1key);
            Object value2 = json2.opt(json1key);
            if (value1 == null && value2 == null) continue;
            if (value1 == null || value2 == null) {
                return false;
            }
            if (!value1.getClass().equals(value2.getClass())) {
                return false;
            }
            if (!(value1 instanceof JSONObject ? !this.compareJson((JSONObject)value1, (JSONObject)value2) : (value1 instanceof JSONArray ? !this.compareJson((JSONArray)value1, (JSONArray)value2) : !this.compareJson(value1, value2)))) continue;
            return false;
        }
        return true;
    }

    private boolean compareJson(JSONArray json1, JSONArray json2) {
        if (json1 == null && json2 == null) {
            return true;
        }
        if (json1 == null || json2 == null) {
            return false;
        }
        if (json1.length() != json2.length()) {
            return false;
        }
        for (int i = 0; i < json1.length(); ++i) {
            Object value1 = json1.opt(i);
            Object value2 = json2.opt(i);
            if (value1 == null || value2 == null) {
                return false;
            }
            if (!value1.getClass().equals(value2.getClass())) {
                return false;
            }
            if (!(value1 instanceof JSONObject ? !this.compareJson((JSONObject)value1, (JSONObject)value2) : (value1 instanceof JSONArray ? !this.compareJson((JSONArray)value1, (JSONArray)value2) : !this.compareJson(value1, value2)))) continue;
            return false;
        }
        return true;
    }

    private boolean compareJson(Object value1, Object value2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public static enum Type {
        VERTEX("vertex"),
        TIMESERIES("timeseries");

        String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

