/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk;

import com.itculate.sdk.types.NumberTypedValue;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class Vertex {
    private String type;
    private String name;
    private Map<String, String> keys;
    private JSONObject data;
    private Map<String, NumberTypedValue> attributeToTypedValue;

    private Vertex(Builder builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.keys = builder.keys;
        this.data = builder.data;
        this.attributeToTypedValue = new HashMap<String, NumberTypedValue>();
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getKeys() {
        return this.keys;
    }

    public JSONObject getData() {
        return this.data;
    }

    boolean hasNumberTypedValue() {
        return this.getAttributeToTypedValue().size() > 0;
    }

    Map<String, NumberTypedValue> getAttributeToTypedValue() {
        return this.attributeToTypedValue;
    }

    public void addProperty(String property, NumberTypedValue value) {
        this.data.put(property, (Object)value.getValue());
        this.attributeToTypedValue.put(property, value);
    }

    public void addProperty(String property, String value) {
        this.data.put(property, (Object)value);
    }

    public void addProperty(String property, boolean value) {
        this.data.put(property, value);
    }

    public String getDefaultKey() {
        return this.keys.values().iterator().next();
    }

    public static Builder builder() {
        return new Builder();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("_type", (Object)this.type);
        jsonObject.put("_name", (Object)this.name);
        JSONObject jsonKeys = new JSONObject();
        for (Map.Entry<String, String> entry : this.keys.entrySet()) {
            jsonKeys.put(entry.getKey(), (Object)entry.getValue());
        }
        jsonObject.put("_keys", (Object)jsonKeys);
        if (this.data != null) {
            for (Map.Entry<String, String> key : this.data.keySet()) {
                String skey = (String)((Object)key);
                jsonObject.put(skey, this.data.get(skey));
            }
        }
        return jsonObject;
    }

    public static class Builder {
        private String type;
        private String name;
        private Map<String, String> keys;
        private JSONObject data;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder keys(Map<String, String> keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(String key) {
            this.keys = new HashMap<String, String>();
            this.keys.put("pk", key);
            return this;
        }

        public Builder data(JSONObject data) {
            this.data = data;
            return this;
        }

        public Vertex build() {
            if (this.type == null || this.name == null || this.keys == null) {
                throw new IllegalStateException("getTypedValue, name and keys must be provided");
            }
            if (this.keys.isEmpty()) {
                throw new IllegalStateException("keys cannot be empty");
            }
            if (this.data == null) {
                this.data = new JSONObject();
            }
            return new Vertex(this);
        }
    }
}

