/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk;

import com.itculate.sdk.Edge;
import com.itculate.sdk.Event;
import com.itculate.sdk.ITculateApiException;
import com.itculate.sdk.Sample;
import com.itculate.sdk.Vertex;
import com.itculate.sdk.payloads.DictionaryPayload;
import com.itculate.sdk.payloads.EventsPayload;
import com.itculate.sdk.payloads.Payload;
import com.itculate.sdk.payloads.TimeseriesPayload;
import com.itculate.sdk.payloads.TopologyPayload;
import com.itculate.sdk.provider.AgentProvider;
import com.itculate.sdk.provider.Provider;
import com.itculate.sdk.provider.SynchronousApiProvider;
import com.itculate.sdk.types.DataType;
import com.itculate.sdk.types.NumberTypedValue;
import java.util.HashMap;
import java.util.Map;

public class ITculateSDK {
    private static String _DEFAULT_COLLECTOR_ID = "sdk";
    private Provider provider;
    private CollectorsPayloads<TopologyPayload> topologyPayloads = new CollectorsPayloads<TopologyPayload>(){

        @Override
        public TopologyPayload createPayload(String createPayload) {
            return new TopologyPayload(createPayload);
        }
    };
    private CollectorsPayloads<TimeseriesPayload> timeseriesPayloads = new CollectorsPayloads<TimeseriesPayload>(){

        @Override
        public TimeseriesPayload createPayload(String createPayload) {
            return new TimeseriesPayload(createPayload);
        }
    };
    private CollectorsPayloads<DictionaryPayload> dictionaryPayloads = new CollectorsPayloads<DictionaryPayload>(){

        @Override
        public DictionaryPayload createPayload(String createPayload) {
            return new DictionaryPayload(createPayload);
        }
    };
    private CollectorsPayloads<EventsPayload> eventsPayloads = new CollectorsPayloads<EventsPayload>(){

        @Override
        public EventsPayload createPayload(String createPayload) {
            return new EventsPayload(createPayload);
        }
    };

    private ITculateSDK(Provider provider) {
        this.provider = provider;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void addVertex(String collectorId, Vertex vertex) throws ITculateApiException {
        TopologyPayload topologyPayload = (TopologyPayload)((CollectorsPayloads)this.topologyPayloads).getPayload(collectorId);
        topologyPayload.add(vertex);
        DictionaryPayload dictionaryPayload = (DictionaryPayload)((CollectorsPayloads)this.dictionaryPayloads).getPayload(ITculateSDK._DEFAULT_COLLECTOR_ID);
        for (Map.Entry<String, NumberTypedValue> entry : vertex.getAttributeToTypedValue().entrySet()) {
            String attribute = entry.getKey();
            DataType dataType = entry.getValue().getDataType();
            String vertexKey = vertex.getDefaultKey();
            dictionaryPayload.add(vertexKey, DictionaryPayload.Type.VERTEX, attribute, dataType);
        }
    }

    public void addEdge(String collectorId, Edge edge) {
        TopologyPayload topologyPayload = (TopologyPayload)((CollectorsPayloads)this.topologyPayloads).getPayload(collectorId);
        topologyPayload.add(edge);
    }

    public void addEvent(Event event) {
        EventsPayload eventsPayload = (EventsPayload)((CollectorsPayloads)this.eventsPayloads).getPayload(ITculateSDK._DEFAULT_COLLECTOR_ID);
        eventsPayload.add(event);
    }

    public void addSample(Sample sample) {
        TimeseriesPayload timeseriesPayload = (TimeseriesPayload)((CollectorsPayloads)this.timeseriesPayloads).getPayload(ITculateSDK._DEFAULT_COLLECTOR_ID);
        timeseriesPayload.add(sample);
        if (sample.getDataType() != null) {
            DictionaryPayload dictionaryPayload = (DictionaryPayload)((CollectorsPayloads)this.dictionaryPayloads).getPayload(ITculateSDK._DEFAULT_COLLECTOR_ID);
            dictionaryPayload.add(sample.getVertexKey(), DictionaryPayload.Type.TIMESERIES, sample.getCounter(), sample.getDataType());
        }
    }

    public void flushAll() throws ITculateApiException {
        ((CollectorsPayloads)this.topologyPayloads).flush(true);
        ((CollectorsPayloads)this.timeseriesPayloads).flush(true);
        ((CollectorsPayloads)this.dictionaryPayloads).flush(false);
        ((CollectorsPayloads)this.eventsPayloads).flush(true);
    }

    public void print() {
        ((CollectorsPayloads)this.topologyPayloads).print();
        ((CollectorsPayloads)this.timeseriesPayloads).print();
        ((CollectorsPayloads)this.dictionaryPayloads).print();
    }

    abstract class CollectorsPayloads<T extends Payload> {
        Map<String, T> collectorIdToPayloads = new HashMap<String, T>();

        CollectorsPayloads() {
        }

        private T getPayload(String collectorId) {
            Payload payload = (Payload)this.collectorIdToPayloads.get(collectorId);
            if (payload == null) {
                payload = this.createPayload(collectorId);
            }
            this.collectorIdToPayloads.put(collectorId, payload);
            return (T)payload;
        }

        private void print() {
            for (Payload payload : this.collectorIdToPayloads.values()) {
                System.out.println(payload.getClass().getSimpleName() + " collectorId: " + payload.getCollectorId());
            }
        }

        private void flush(boolean reset) throws ITculateApiException {
            for (Payload payload : this.collectorIdToPayloads.values()) {
                String className = payload.getClass().getSimpleName();
                String collectorId = payload.getCollectorId();
                if (payload.changed()) {
                    ITculateSDK.this.provider.flush(payload.getCollectorId(), payload.toJson(reset));
                    continue;
                }
                System.out.println("Flush skipped, no change " + className + " collectorId: " + collectorId);
            }
        }

        protected abstract T createPayload(String var1);
    }

    public static class Builder {
        private String serverUrl = null;
        private boolean agent = true;
        private String apiKey;
        private String apiSecret;
        private Provider provider;

        public Builder serverUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder agent(boolean agent) {
            this.agent = agent;
            return this;
        }

        public Builder provider(Provider provider) {
            this.provider = provider;
            this.agent = false;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return this;
        }

        public ITculateSDK build() {
            if (this.provider != null) {
                if (this.agent) {
                    throw new IllegalStateException("When use provider, agent cannot be set");
                }
                if (this.serverUrl != null) {
                    throw new IllegalStateException("When use provider, serverUrl cannot be set");
                }
                if (this.apiKey != null || this.apiSecret != null) {
                    throw new IllegalStateException("When use provider, apiKey and apiSecret cannot be set");
                }
            } else {
                this.provider = this.agent ? new AgentProvider(this.serverUrl) : new SynchronousApiProvider(this.serverUrl, this.apiKey, this.apiSecret);
            }
            return new ITculateSDK(this.provider);
        }
    }
}

