/*
 * Decompiled with CFR 0.152.
 */
package com.itculate.sdk;

import com.itculate.sdk.Vertex;
import org.json.JSONObject;

public class Event {
    private final String vertexKey;
    private final String eventType;
    private final String message;
    private final String severity;
    private final long timestamp;

    private Event(Builder builder) {
        this.vertexKey = builder.vertexKey;
        this.eventType = builder.eventType;
        this.message = builder.message;
        this.severity = builder.severity;
        this.timestamp = builder.timestamp;
    }

    public String getVertexKey() {
        return this.vertexKey;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSeverity() {
        return this.severity;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getEventType() {
        return this.eventType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HealthyBuilder healthyBuilder() {
        return new HealthyBuilder();
    }

    public static UnhealthyBuilder unhealthyBuilder() {
        return new UnhealthyBuilder();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("vertex_key", (Object)this.vertexKey);
        jsonObject.put("event_time", this.timestamp / 1000L);
        jsonObject.put("event_type", (Object)this.eventType);
        jsonObject.put("severity", (Object)this.severity);
        jsonObject.put("message", (Object)this.message);
        return jsonObject;
    }

    public static class UnhealthyBuilder {
        String vertexKey;
        String message;
        long timestamp = 0L;

        public UnhealthyBuilder vertexKey(String vertexKey) {
            this.vertexKey = vertexKey;
            return this;
        }

        public UnhealthyBuilder vertexKey(Vertex vertex) {
            this.vertexKey = vertex.getDefaultKey();
            return this;
        }

        public UnhealthyBuilder message(String message) {
            this.message = message;
            return this;
        }

        public UnhealthyBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Event build() {
            return new Builder().vertexKey(this.vertexKey).message(this.message).severity("ERROR").eventType("UNHEALTHY").timestamp(this.timestamp).build();
        }
    }

    public static class HealthyBuilder {
        String vertexKey;
        String message;
        long timestamp = 0L;

        public HealthyBuilder vertexKey(String vertexKey) {
            this.vertexKey = vertexKey;
            return this;
        }

        public HealthyBuilder vertexKey(Vertex vertex) {
            this.vertexKey = vertex.getDefaultKey();
            return this;
        }

        public HealthyBuilder message(String message) {
            this.message = message;
            return this;
        }

        public HealthyBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Event build() {
            return new Builder().vertexKey(this.vertexKey).message(this.message).severity("SUCCESS").eventType("HEALTHY").timestamp(this.timestamp).build();
        }
    }

    public static class Builder {
        String vertexKey;
        String eventType;
        String message;
        String severity;
        long timestamp = 0L;

        public Builder vertexKey(String vertexKey) {
            this.vertexKey = vertexKey;
            return this;
        }

        public Builder vertexKey(Vertex vertex) {
            this.vertexKey = vertex.getDefaultKey();
            return this;
        }

        public Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Event build() {
            if (this.vertexKey == null) {
                throw new IllegalStateException("vertexKey must be set");
            }
            if (this.eventType == null) {
                throw new IllegalStateException("eventType must be set");
            }
            if (this.severity == null) {
                throw new IllegalStateException("severity must be set");
            }
            if (this.message == null) {
                throw new IllegalStateException("message must be set");
            }
            if (this.timestamp == 0L) {
                this.timestamp = System.currentTimeMillis();
            }
            return new Event(this);
        }
    }
}

