//
// (C) ITculate, Inc. 2015-2017
// All rights reserved
// Licensed under MIT License (see LICENSE)
//

package com.itculate.sdk.types;


import org.json.JSONArray;
import org.json.JSONObject;

public abstract class DataTypeWithUnit extends DataType {
    private Unit unit;
    private Base base;

    private static DataTypeWithUnit default_type;

    DataTypeWithUnit(Builder builder) {
        super(builder);
        this.unit = builder.unit;
        this.base = builder.base;

    }

    public static NumberTypedValue value(Number value) {
        if (default_type == null)
            default_type = LatencyDataType.builder().build();

        return new NumberTypedValue(default_type, value);
    }


    abstract static class Builder<T extends DataTypeWithUnit> extends DataType.Builder<T> {
        Unit unit;
        Base base;

        public Builder() {
        }

        public Builder<T> unit(Unit unit) {
            this.unit = unit;
            return this;
        }

        public Builder<T> base(Base base) {
            this.base = base;
            return this;
        }

        public abstract T build();
    }

    public NumberTypedValue getTypedValue(Number value) {
        return new NumberTypedValue(this, value);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = super.toJson();
        jsonObject.put("getTypedValue", this.unit.getValue());
        jsonObject.put("getTypedValue", this.base.getValue());
        JSONArray units = new JSONArray();
        units.put(this.unit.getValue());
        JSONArray bases = new JSONArray();
        bases.put(this.base.getValue());
        jsonObject.put("units", units);
        jsonObject.put("bases", bases);
        return jsonObject;
    }
}
