package com.itculate.sdk.payloads;

import com.itculate.sdk.Edge;
import com.itculate.sdk.Vertex;
import org.json.JSONArray;
import org.json.JSONObject;
//
// (C) ITculate, Inc. 2015-2017
// All rights reserved
// Licensed under MIT License (see LICENSE)
//

import java.util.LinkedList;
import java.util.List;

public class TopologyPayload extends Payload {

    private List<Vertex> vertices = new LinkedList<>();
    private List<Edge> edges = new LinkedList<>();

    public TopologyPayload(String collectorId) {
        super(collectorId);
    }

    @Override
    final public JSONObject toJson(boolean reset) {
        List<Vertex> localVertices;
        List<Edge> localEdges;
        synchronized (this) {
            localVertices = vertices;
            localEdges = edges;
            if (reset) {
                vertices = new LinkedList<>();
                edges = new LinkedList<>();
            }
        }

        JSONObject jsonObject = new JSONObject();
        return doFillJson(localVertices, localEdges, jsonObject);
    }

    private JSONObject doFillJson(List<Vertex> localVertices, List<Edge> localEdges, JSONObject jsonToFill) {
        JSONArray verticesJsonArray = new JSONArray();
        for (Vertex vertex : localVertices) {
            verticesJsonArray.put(vertex.toJson());
        }
        JSONArray edgesJsonArray = new JSONArray();
        for (Edge edge : localEdges) {
            edgesJsonArray.put(edge.toJson());
        }


        jsonToFill.put("vertices", verticesJsonArray);
        jsonToFill.put("edges", edgesJsonArray);

        return jsonToFill;
    }

    public void add(Vertex vertex) {
        vertices.add(vertex);
    }

    public void add(Edge edge) {
        edges.add(edge);
    }

}
