//
// (C) ITculate, Inc. 2015-2017
// All rights reserved
// Licensed under MIT License (see LICENSE)
//

package com.itculate.sdk.payloads;

import com.itculate.sdk.Sample;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.LinkedList;
import java.util.List;

public class TimeseriesPayload extends Payload {

    private List<Sample> samples = new LinkedList<>();


    public TimeseriesPayload(String collectorId) {
        super(collectorId);
    }

    @Override
    public boolean changed() {
        return true;
    }

    @Override
    final public JSONObject toJson(boolean reset) {
        List<Sample> localSamples;
        synchronized (this) {
            localSamples = samples;
            if (reset)
                samples = new LinkedList<>();
        }

        JSONObject jsonObject = new JSONObject();
        doFillJson(localSamples, jsonObject);
        return jsonObject;
    }


    private void doFillJson(List<Sample> localSamples, JSONObject jsonToFill) {
        JSONObject jsonObject = new JSONObject();
        for (Sample sample : localSamples) {
            String vertexKey = sample.getVertexKey();
            String counter = sample.getCounter();
            Number value = sample.getValue();

            // ITculate json format is double in Sec
            double timestamp = sample.getTimestamp() / 1000;

            JSONObject counterValues = jsonObject.optJSONObject(vertexKey);
            if (counterValues == null) {
                counterValues = new JSONObject();
                jsonObject.put(vertexKey, counterValues);
            }

            JSONArray values = counterValues.optJSONArray(counter);
            if (values == null)
                values = new JSONArray();
            counterValues.put(counter, values);

            JSONArray timestampValueTuple = new JSONArray();
            timestampValueTuple.put(timestamp);
            timestampValueTuple.put(value);
            values.put(timestampValueTuple);
        }

        jsonToFill.put("samples", jsonObject);
    }


    public void add(Sample sample) {
        samples.add(sample);
    }
}
