//
// (C) ITculate, Inc. 2015-2017
// All rights reserved
// Licensed under MIT License (see LICENSE)
//

package com.itculate.sdk.payloads;

import org.json.JSONObject;

public abstract class Payload {

    private String collectorId;

    Payload(String collectorId) {
        this.collectorId = collectorId;
    }

    public String getCollectorId() {
        return collectorId;
    }


    abstract public JSONObject toJson(boolean reset);

    public boolean changed() {
        return true;
    }

    @Override
    public String toString() {
        return this.toJson(false).toString();
    }

}
