package com.itculate.sdk.payloads;

import com.itculate.sdk.Event;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.LinkedList;
import java.util.List;

//
// (C) ITculate, Inc. 2015-2017
// All rights reserved
// Licensed under MIT License (see LICENSE)
//

public class EventsPayload extends Payload {

    private List<Event> events = new LinkedList<>();

    public EventsPayload(String collectorId) {
        super(collectorId);
    }

    @Override
    final public JSONObject toJson(boolean reset) {
        List<Event> localEvents;
        synchronized (this) {
            localEvents = events;
            if (reset) {
                events = new LinkedList<>();
            }
        }

        JSONObject jsonObject = new JSONObject();
        return doFillJson(localEvents, jsonObject);
    }

    private JSONObject doFillJson(List<Event> localEvents, JSONObject jsonToFill) {
        JSONArray eventsJsonArray = new JSONArray();
        for (Event event: localEvents) {
            eventsJsonArray.put(event.toJson());
        }

        jsonToFill.put("events", eventsJsonArray);

        return jsonToFill;
    }

    public void add(Event event) {
        events.add(event);
    }

}
