//
// (C) ITculate, Inc. 2015-2017
// All rights reserved
// Licensed under MIT License (see LICENSE)
//

package com.itculate.sdk;

import com.itculate.sdk.types.DataType;
import com.itculate.sdk.types.NumberTypedValue;

public class Sample {

    private final String vertexKey;
    private final String counter;
    private final Number value;
    private final long timestamp;

    private final DataType dataType;

    private Sample(Builder builder) {
        this.vertexKey = builder.vertexKey;
        this.counter = builder.counter;
        this.value = builder.value;
        this.timestamp = builder.timestamp;
        this.dataType = builder.dataType;
    }

    public String getVertexKey() {
        return vertexKey;
    }

    public String getCounter() {
        return counter;
    }

    public Number getValue() {
        return value;
    }

    public long getTimestamp() {
        return timestamp;
    }

    DataType getDataType() {
        // used internal for populating dictionary
        return dataType;
    }

    static public Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String vertexKey;
        String counter;
        Number value;
        DataType dataType;
        long timestamp = 0;

        public Builder vertexKey(String vertexKey) {
            this.vertexKey = vertexKey;
            return this;
        }

        public Builder vertexKey(Vertex vertex) {
            this.vertexKey = vertex.getDefaultKey();
            return this;
        }

        public Builder counter(String counter) {
            this.counter = counter;
            return this;
        }

        public Builder value(Number value) {
            this.value = value;
            return this;
        }

        public Builder value(NumberTypedValue value) {
            this.value = value.getValue();
            this.dataType = value.getDataType();
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Sample build() {

            if (this.vertexKey == null)
                throw new IllegalStateException("vertexKey must be set");

            if (this.counter == null)
                throw new IllegalStateException("message must be set");

            if (this.value == null)
                throw new IllegalStateException("getTypedValue must be set");

            if (this.timestamp == 0)
                this.timestamp = System.currentTimeMillis();

            return new Sample(this);
        }
    }
}
