/*
 * Decompiled with CFR 0.152.
 */
package io.interact.sqsdw;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SqsFactory.class);
    @JsonProperty
    private String awsAccessKeyId;
    @JsonProperty
    private String awsSecretKey;
    @JsonProperty
    private String awsRegion;
    @JsonIgnore
    private AmazonSQS sqs;

    public AmazonSQS build(Environment env) {
        LOG.info("Initialize Amazon SQS entry point");
        this.sqs = StringUtils.isEmpty((CharSequence)this.awsAccessKeyId) || StringUtils.isEmpty((CharSequence)this.awsSecretKey) ? new AmazonSQSClient((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain()) : new AmazonSQSClient((AWSCredentials)new BasicAWSCredentials(this.awsAccessKeyId, this.awsSecretKey));
        Regions regions = StringUtils.isNotEmpty((CharSequence)this.awsRegion) ? Regions.fromName((String)this.awsRegion) : Regions.DEFAULT_REGION;
        this.sqs.setRegion(Region.getRegion((Regions)regions));
        env.lifecycle().manage(new Managed(){

            public void start() {
            }

            public void stop() {
                LOG.info("Shutdown Amazon SQS entry point");
                SqsFactory.this.sqs.shutdown();
            }
        });
        return this.sqs;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public void setAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }
}

