/*
 * Decompiled with CFR 0.152.
 */
package io.interact.sqsdw;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SqsFactory.class);
    @NotEmpty
    @JsonProperty
    private String awsAccessKeyId;
    @NotEmpty
    @JsonProperty
    private String awsSecretKey;
    @NotEmpty
    @JsonProperty
    private String awsRegion;

    public AmazonSQS build(Environment env) {
        LOG.info("Initialize Amazon SQS entry point");
        AWSCredentials credentials = new AWSCredentials(){

            public String getAWSSecretKey() {
                return SqsFactory.this.awsSecretKey;
            }

            public String getAWSAccessKeyId() {
                return SqsFactory.this.awsAccessKeyId;
            }
        };
        AmazonSQSClient sqs = new AmazonSQSClient(credentials);
        Region region = Region.getRegion((Regions)Regions.fromName((String)this.awsRegion));
        sqs.setRegion(region);
        env.lifecycle().manage(new Managed((AmazonSQS)sqs){
            final /* synthetic */ AmazonSQS val$sqs;
            {
                this.val$sqs = amazonSQS;
            }

            public void start() {
            }

            public void stop() {
                LOG.info("Shutdown Amazon SQS entry point");
                this.val$sqs.shutdown();
            }
        });
        return sqs;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public void setAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }
}

