/*
 * Decompiled with CFR 0.152.
 */
package io.interact.sqsdw;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;

public abstract class MessageHandler {
    public static final String ATTR_MESSAGE_TYPE = "MessageType";
    private String messageType;

    protected MessageHandler(String messageType) {
        if (messageType == null) {
            throw new IllegalArgumentException("Message type cannot be null!");
        }
        this.messageType = messageType;
    }

    public boolean canHandle(Message message) {
        if (message == null) {
            return false;
        }
        MessageAttributeValue attrValue = (MessageAttributeValue)message.getMessageAttributes().get(ATTR_MESSAGE_TYPE);
        if (attrValue == null) {
            return false;
        }
        return attrValue.getStringValue().equalsIgnoreCase(this.messageType);
    }

    public abstract void handle(Message var1);
}

