/*
 * Decompiled with CFR 0.152.
 */
package io.interact.sqsdw;

import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import java.util.HashMap;
import java.util.Map;

public class MessageDispatcher {
    public static void dispatch(String messageBody, String queueUrl, String messageType, AmazonSQS sqs) {
        MessageDispatcher.sendMessage(messageBody, queueUrl, MessageDispatcher.prepareMessageAttributes(messageType), sqs);
    }

    private static Map<String, MessageAttributeValue> prepareMessageAttributes(String messageType) {
        HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>();
        messageAttributes.put("MessageType", new MessageAttributeValue().withDataType("String").withStringValue(messageType));
        return messageAttributes;
    }

    private static void sendMessage(String messageBody, String queueUrl, Map<String, MessageAttributeValue> messageAttributes, AmazonSQS sqs) {
        SendMessageRequest request = new SendMessageRequest();
        request.withMessageBody(messageBody);
        request.withQueueUrl(queueUrl);
        request.withMessageAttributes(messageAttributes);
        sqs.sendMessage(request);
    }
}

