/*
 * Decompiled with CFR 0.152.
 */
package io.interact.dropwizard.logstash.appender;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import io.interact.dropwizard.logstash.appender.AbstractLogstashAppenderFactory;
import io.interact.dropwizard.logstash.appender.LogstashAppenderFactoryHelper;
import java.net.InetSocketAddress;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import net.logstash.logback.appender.LogstashTcpSocketAppender;
import net.logstash.logback.encoder.LogstashEncoder;

@JsonTypeName(value="logstash-tcp")
public class LogstashTcpAppenderFactory
extends AbstractLogstashAppenderFactory {
    @Min(value=1L)
    @Max(value=65535L)
    private int queueSize = 8192;

    public LogstashTcpAppenderFactory() {
        this.port = 4560;
    }

    @JsonProperty
    public int getQueueSize() {
        return this.queueSize;
    }

    @JsonProperty
    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public Appender build(LoggerContext context, String s, LayoutFactory layoutFactory, LevelFilterFactory levelFilterFactory, AsyncAppenderFactory asyncAppenderFactory) {
        LogstashTcpSocketAppender appender = new LogstashTcpSocketAppender();
        LogstashEncoder encoder = new LogstashEncoder();
        appender.setName("logstash-tcp-appender");
        appender.setContext((Context)context);
        appender.addDestinations(new InetSocketAddress[]{new InetSocketAddress(this.host, this.port)});
        appender.setIncludeCallerData(this.includeCallerData);
        appender.setQueueSize(this.queueSize);
        encoder.setIncludeContext(this.includeContext);
        encoder.setIncludeMdc(this.includeMdc);
        encoder.setIncludeCallerData(this.includeCallerData);
        if (this.customFields != null) {
            LogstashAppenderFactoryHelper.getCustomFieldsFromHashMap(this.customFields).ifPresent(arg_0 -> ((LogstashEncoder)encoder).setCustomFields(arg_0));
        }
        if (this.fieldNames != null) {
            encoder.setFieldNames(LogstashAppenderFactoryHelper.getFieldNamesFromHashMap(this.fieldNames));
        }
        appender.setEncoder((Encoder)encoder);
        appender.addFilter(levelFilterFactory.build(this.threshold));
        encoder.start();
        appender.start();
        return this.wrapAsync((Appender)appender, asyncAppenderFactory);
    }
}

