/*
 * Decompiled with CFR 0.152.
 */
package io.infinite.bobbin.destinations;

import groovy.lang.MetaClass;
import groovy.transform.Generated;
import io.infinite.bobbin.BobbinFile;
import io.infinite.bobbin.Level;
import io.infinite.bobbin.config.DestinationConfig;
import io.infinite.bobbin.destinations.Destination;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.slf4j.helpers.Util;

public class FileDestination
extends Destination {
    private ThreadLocal<Map<Level, BobbinFile>> bobbinFileThreadLocalMap;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public FileDestination(DestinationConfig destinationConfig) {
        super(destinationConfig);
        ThreadLocal threadLocal = new ThreadLocal();
        this.bobbinFileThreadLocalMap = threadLocal;
    }

    @Override
    protected void store(String finalOutputMessageText, Level level, String className, String date) {
        String newFileName = this.getBobbinScriptEngine().evalFileName(level.value(), className, date);
        BobbinFile bobbinFile = this.refreshCurrentFile(level, newFileName);
        String string = bobbinFile.getCanonicalPath().intern();
        synchronized (string) {
            bobbinFile.getWriter().write(finalOutputMessageText);
            bobbinFile.getWriter().flush();
        }
    }

    public BobbinFile refreshCurrentFile(Level level, String newFileName) {
        HashMap<Level, BobbinFile> bobbinFileMap = (HashMap<Level, BobbinFile>)ScriptBytecodeAdapter.castToType(this.bobbinFileThreadLocalMap.get(), Map.class);
        if (bobbinFileMap == null) {
            HashMap<Level, BobbinFile> hashMap;
            bobbinFileMap = hashMap = new HashMap<Level, BobbinFile>();
            BobbinFile bobbinFile = this.initFile(newFileName);
            ((HashMap)ScriptBytecodeAdapter.castToType(bobbinFileMap, HashMap.class)).put(level, bobbinFile);
            this.bobbinFileThreadLocalMap.set(bobbinFileMap);
            return bobbinFile;
        }
        if (!bobbinFileMap.containsKey((Object)level)) {
            BobbinFile bobbinFile = this.initFile(newFileName);
            bobbinFileMap.put(level, bobbinFile);
            return bobbinFile;
        }
        BobbinFile bobbinFile = (BobbinFile)ScriptBytecodeAdapter.castToType(bobbinFileMap.get((Object)level), BobbinFile.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)bobbinFile.getFileName(), (Object)newFileName)) {
            BobbinFile bobbinFile2;
            bobbinFile.getWriter().close();
            bobbinFile = bobbinFile2 = this.initFile(newFileName);
            bobbinFileMap.put(level, bobbinFile);
        }
        return bobbinFile;
    }

    public BobbinFile initFile(String fileName) {
        BobbinFile file = new BobbinFile(fileName);
        String string = fileName;
        file.setFileName(string);
        file.getParentFile().mkdirs();
        FileWriter fileWriter = new FileWriter((File)file, true);
        file.setWriter(fileWriter);
        return file;
    }

    static {
        Util.report((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Bobbin: ", (CharSequence)StringGroovyMethods.padRight((CharSequence)Thread.currentThread().getName(), (Number)16)), (CharSequence)": "), (CharSequence)"application working dir: "), (CharSequence)new BobbinFile("./").getCanonicalPath()));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileDestination.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public ThreadLocal<Map<Level, BobbinFile>> getBobbinFileThreadLocalMap() {
        return this.bobbinFileThreadLocalMap;
    }

    @Generated
    public void setBobbinFileThreadLocalMap(ThreadLocal<Map<Level, BobbinFile>> threadLocal) {
        this.bobbinFileThreadLocalMap = threadLocal;
    }
}

